/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.datatype.Lyrics3Line;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.StringHashMap;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3TextEncodingConversion;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyUSLT
extends AbstractID3v2FrameBody
implements ID3v23FrameBody,
ID3v24FrameBody {
    public FrameBodyUSLT() {
    }

    public FrameBodyUSLT(FrameBodyUSLT body) {
        super(body);
    }

    public FrameBodyUSLT(byte textEncoding, String language, String description, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setObjectValue("Language", language);
        this.setObjectValue("Description", description);
        this.setObjectValue("Lyrics", text);
    }

    public FrameBodyUSLT(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public void setDescription(String description) {
        this.setObjectValue("Description", description);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    public String getIdentifier() {
        return "USLT";
    }

    public void setLanguage(String language) {
        this.setObjectValue("Language", language);
    }

    public String getLanguage() {
        return (String)this.getObjectValue("Language");
    }

    public void setLyric(String lyric) {
        this.setObjectValue("Lyrics", lyric);
    }

    public String getLyric() {
        return (String)this.getObjectValue("Lyrics");
    }

    public String getFirstTextValue() {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Lyrics");
        return text.getValueAtIndex(0);
    }

    public void addLyric(String text) {
        this.setLyric(this.getLyric() + text);
    }

    public void addLyric(Lyrics3Line line) {
        this.setLyric(this.getLyric() + line.writeString());
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        this.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this.getHeader(), (byte)0));
        if (!((AbstractString)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        if (!((AbstractString)this.getObject("Lyrics")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        super.write(tagBuffer);
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringHashMap("Language", (AbstractTagFrameBody)this, 3));
        this.objectList.add(new TextEncodedStringNullTerminated("Description", this));
        this.objectList.add(new TextEncodedStringSizeTerminated("Lyrics", this));
    }
}

