/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.StringHashMap;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3TextEncodingConversion;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyCOMM
extends AbstractID3v2FrameBody
implements ID3v24FrameBody,
ID3v23FrameBody {
    public static final String DEFAULT = "";
    public static final String ITUNES_NORMALIZATION = "iTunNORM";

    public FrameBodyCOMM() {
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Language", "eng");
        this.setObjectValue("Description", DEFAULT);
        this.setObjectValue("Text", DEFAULT);
    }

    public FrameBodyCOMM(FrameBodyCOMM body) {
        super(body);
    }

    public FrameBodyCOMM(byte textEncoding, String language, String description, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setObjectValue("Language", language);
        this.setObjectValue("Description", description);
        this.setObjectValue("Text", text);
    }

    public FrameBodyCOMM(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.setObjectValue("Description", description);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    public String getIdentifier() {
        return "COMM";
    }

    public void setLanguage(String language) {
        this.setObjectValue("Language", language);
    }

    public String getLanguage() {
        return (String)this.getObjectValue("Language");
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.setObjectValue("Text", text);
    }

    public String getText() {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return text.getValueAtIndex(0);
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringHashMap("Language", (AbstractTagFrameBody)this, 3));
        this.objectList.add(new TextEncodedStringNullTerminated("Description", this));
        this.objectList.add(new TextEncodedStringSizeTerminated("Text", this));
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        this.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this.getHeader(), this.getTextEncoding()));
        if (!((AbstractString)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        if (!((AbstractString)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        super.write(tagBuffer);
    }
}

