/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ID3Unsynchronization {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.id3");

    public static boolean requiresUnsynchronization(byte[] abySource) {
        for (int i = 0; i < abySource.length - 1; ++i) {
            if ((abySource[i] & 0xFF) != 255 || (abySource[i + 1] & 0xE0) != 224) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Unsynchronisation required found bit at:" + i);
            }
            return true;
        }
        return false;
    }

    public static byte[] unsynchronize(byte[] abySource) {
        ByteArrayInputStream input = new ByteArrayInputStream(abySource);
        ByteArrayOutputStream output = new ByteArrayOutputStream(abySource.length);
        int count = 0;
        while (input.available() > 0) {
            int firstByte = input.read();
            ++count;
            output.write(firstByte);
            if ((firstByte & 0xFF) != 255 || input.available() <= 0) continue;
            input.mark(1);
            int secondByte = input.read();
            if ((secondByte & 0xE0) == 224) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Writing unsynchronisation bit at:" + count);
                }
                output.write(0);
            } else if (secondByte == 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Inserting zero unsynchronisation bit at:" + count);
                }
                output.write(0);
            }
            input.reset();
        }
        if ((abySource[abySource.length - 1] & 0xFF) == 255) {
            logger.finest("Adding unsynchronisation bit at end of stream");
            output.write(0);
        }
        return output.toByteArray();
    }

    public static ByteBuffer synchronize(ByteBuffer source) {
        int bufferSize = source.limit();
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream(bufferSize);
        int position = 0;
        while (position < bufferSize) {
            byte byteValue = source.get();
            oBAOS.write(byteValue);
            if ((byteValue & 0xFF) != 255 || ++position >= bufferSize) continue;
            byte unsyncByteValue = source.get();
            ++position;
            if (unsyncByteValue == 0) continue;
            oBAOS.write(unsyncByteValue);
        }
        return ByteBuffer.wrap(oBAOS.toByteArray());
    }
}

