/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jaudiotagger.tag.id3.AbstractID3Tag;

public abstract class AbstractID3v1Tag
extends AbstractID3Tag {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.id3");
    protected static final byte END_OF_FIELD = 0;
    protected static Pattern endofStringPattern = Pattern.compile("\\x00");
    protected static final byte[] TAG_ID = new byte[]{84, 65, 71};
    protected static final int TAG_LENGTH = 128;
    protected static final int TAG_DATA_LENGTH = 125;
    protected static final int FIELD_TAGID_LENGTH = 3;
    protected static final int FIELD_TITLE_LENGTH = 30;
    protected static final int FIELD_ARTIST_LENGTH = 30;
    protected static final int FIELD_ALBUM_LENGTH = 30;
    protected static final int FIELD_YEAR_LENGTH = 4;
    protected static final int FIELD_GENRE_LENGTH = 1;
    protected static final int FIELD_TAGID_POS = 0;
    protected static final int FIELD_TITLE_POS = 3;
    protected static final int FIELD_ARTIST_POS = 33;
    protected static final int FIELD_ALBUM_POS = 63;
    protected static final int FIELD_YEAR_POS = 93;
    protected static final int FIELD_GENRE_POS = 127;
    protected static final String TYPE_TITLE = "title";
    protected static final String TYPE_ARTIST = "artist";
    protected static final String TYPE_ALBUM = "album";
    protected static final String TYPE_YEAR = "year";
    protected static final String TYPE_GENRE = "genre";

    public AbstractID3v1Tag() {
    }

    public AbstractID3v1Tag(AbstractID3v1Tag copyObject) {
        super(copyObject);
    }

    public int getSize() {
        return 128;
    }

    public void delete(RandomAccessFile file) throws IOException {
        logger.info("Deleting ID3v1 from file if exists");
        FileChannel fc = file.getChannel();
        fc.position(file.length() - 128L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        fc.read(byteBuffer);
        byteBuffer.rewind();
        if (this.seek(byteBuffer)) {
            logger.info("Deleted ID3v1 tag ");
            file.setLength(file.length() - 128L);
        } else {
            logger.info("Unable to find ID3v1 tag to deleteField");
        }
    }
}

