/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.flac;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.reference.PictureTypes;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlacTag
implements Tag {
    private VorbisCommentTag tag = null;
    private List<MetadataBlockDataPicture> images = new ArrayList<MetadataBlockDataPicture>();

    public FlacTag(VorbisCommentTag tag, List<MetadataBlockDataPicture> images) {
        this.tag = tag;
        this.images = images;
    }

    public List<MetadataBlockDataPicture> getImages() {
        return this.images;
    }

    public VorbisCommentTag getVorbisCommentTag() {
        return this.tag;
    }

    @Override
    public void addField(TagField field) throws FieldDataInvalidException {
        if (field instanceof MetadataBlockDataPicture) {
            this.images.add((MetadataBlockDataPicture)field);
        } else {
            this.tag.addField(field);
        }
    }

    @Override
    public List<TagField> get(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            ArrayList<TagField> castImages = new ArrayList<TagField>();
            for (MetadataBlockDataPicture image : this.images) {
                castImages.add(image);
            }
            return castImages;
        }
        return this.tag.get(id);
    }

    @Override
    public boolean hasCommonFields() {
        return this.tag.hasCommonFields();
    }

    @Override
    public boolean hasField(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            return this.images.size() > 0;
        }
        return this.tag.hasField(id);
    }

    @Override
    public boolean isEmpty() {
        return (this.tag == null || this.tag.isEmpty()) && this.images.size() == 0;
    }

    @Override
    public void setField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    public void setField(String vorbisCommentKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(vorbisCommentKey, value);
        this.setField(tagfield);
    }

    public void addField(String vorbisCommentKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(vorbisCommentKey, value);
        this.addField(tagfield);
    }

    @Override
    public void setField(TagField field) throws FieldDataInvalidException {
        if (field instanceof MetadataBlockDataPicture) {
            if (this.images.size() == 0) {
                this.images.add(0, (MetadataBlockDataPicture)field);
            } else {
                this.images.set(0, (MetadataBlockDataPicture)field);
            }
        } else {
            this.tag.setField(field);
        }
    }

    @Override
    public TagField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey.equals((Object)FieldKey.COVER_ART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(genericKey, value);
    }

    public TagField createField(VorbisCommentFieldKey vorbisCommentFieldKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (vorbisCommentFieldKey.equals((Object)VorbisCommentFieldKey.COVERART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(vorbisCommentFieldKey, value);
    }

    public TagField createField(String vorbisCommentFieldKey, String value) {
        if (vorbisCommentFieldKey.equals(VorbisCommentFieldKey.COVERART.getFieldName())) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(vorbisCommentFieldKey, value);
    }

    @Override
    public String getFirst(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getFirst(id);
    }

    @Override
    public String getFirst(FieldKey id) throws KeyNotFoundException {
        if (id.equals((Object)FieldKey.COVER_ART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_RETRIEVED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getFirst(id);
    }

    @Override
    public TagField getFirstField(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            if (this.images.size() > 0) {
                return this.images.get(0);
            }
            return null;
        }
        return this.tag.getFirstField(id);
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (genericKey == FieldKey.COVER_ART) {
            return this.getFirstField(FieldKey.COVER_ART.name());
        }
        return this.tag.getFirstField(genericKey);
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey.equals((Object)FieldKey.COVER_ART)) {
            this.images.clear();
        } else {
            this.tag.deleteField(fieldKey);
        }
    }

    @Override
    public Iterator<TagField> getFields() {
        return this.tag.getFields();
    }

    @Override
    public int getFieldCount() {
        return this.tag.getFieldCount() + this.images.size();
    }

    @Override
    public boolean setEncoding(String enc) throws FieldDataInvalidException {
        return this.tag.setEncoding(enc);
    }

    @Override
    public List<TagField> getFields(FieldKey id) throws KeyNotFoundException {
        if (id.equals((Object)FieldKey.COVER_ART)) {
            ArrayList<TagField> castImages = new ArrayList<TagField>();
            for (MetadataBlockDataPicture image : this.images) {
                castImages.add(image);
            }
            return castImages;
        }
        return this.tag.getFields(id);
    }

    public TagField createArtworkField(byte[] imageData, int pictureType, String mimeType, String description, int width, int height, int colourDepth, int indexedColouredCount) throws FieldDataInvalidException {
        return new MetadataBlockDataPicture(imageData, pictureType, mimeType, description, width, height, colourDepth, indexedColouredCount);
    }

    public TagField createArtworkField(BufferedImage bi, int pictureType, String mimeType, String description, int colourDepth, int indexedColouredCount) throws FieldDataInvalidException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, ImageFormats.getFormatForMimeType(mimeType), new DataOutputStream(output));
            return new MetadataBlockDataPicture(output.toByteArray(), pictureType, mimeType, description, bi.getWidth(), bi.getHeight(), colourDepth, indexedColouredCount);
        }
        catch (IOException ioe) {
            throw new FieldDataInvalidException("Unable to convert image to bytearray, check mimetype parameter");
        }
    }

    public TagField createLinkedArtworkField(String url) {
        return new MetadataBlockDataPicture(Utils.getDefaultBytes(url, "ISO-8859-1"), PictureTypes.DEFAULT_ID, "-->", "", 0, 0, 0, 0);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        BufferedImage image;
        if (artwork.isLinked()) {
            return new MetadataBlockDataPicture(Utils.getDefaultBytes(artwork.getImageUrl(), "ISO-8859-1"), artwork.getPictureType(), "-->", "", 0, 0, 0, 0);
        }
        try {
            image = artwork.getImage();
        }
        catch (IOException ioe) {
            throw new FieldDataInvalidException("Unable to createField bufferd image from the image");
        }
        return new MetadataBlockDataPicture(artwork.getBinaryData(), artwork.getPictureType(), artwork.getMimeType(), artwork.getDescription(), image.getWidth(), image.getHeight(), 0, 0);
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public List<Artwork> getArtworkList() {
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(this.images.size());
        for (MetadataBlockDataPicture coverArt : this.images) {
            Artwork artwork = new Artwork();
            artwork.setMimeType(coverArt.getMimeType());
            artwork.setDescription(coverArt.getDescription());
            artwork.setPictureType(coverArt.getPictureType());
            if (coverArt.isImageUrl()) {
                artwork.setLinked(coverArt.isImageUrl());
                artwork.setImageUrl(coverArt.getImageUrl());
            } else {
                artwork.setBinaryData(coverArt.getImageData());
            }
            artworkList.add(artwork);
        }
        return artworkList;
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> artwork = this.getArtworkList();
        if (artwork.size() > 0) {
            return artwork.get(0);
        }
        return null;
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }
}

