/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.jaudiotagger.tag.datatype.HashMapInterface;
import org.jaudiotagger.tag.datatype.StringFixedLength;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.reference.Languages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHashMap
extends StringFixedLength
implements HashMapInterface<String, String> {
    Map<String, String> keyToValue = null;
    Map<String, String> valueToKey = null;
    boolean hasEmptyValue = false;

    public StringHashMap(String identifier, AbstractTagFrameBody frameBody, int size) {
        super(identifier, frameBody, size);
        if (!identifier.equals("Language")) {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + identifier);
        }
        this.valueToKey = Languages.getInstanceOf().getValueToIdMap();
        this.keyToValue = Languages.getInstanceOf().getIdToValueMap();
    }

    public StringHashMap(StringHashMap copyObject) {
        super(copyObject);
        this.hasEmptyValue = copyObject.hasEmptyValue;
        this.keyToValue = copyObject.keyToValue;
        this.valueToKey = copyObject.valueToKey;
    }

    @Override
    public Map<String, String> getKeyToValue() {
        return this.keyToValue;
    }

    @Override
    public Map<String, String> getValueToKey() {
        return this.valueToKey;
    }

    @Override
    public void setValue(Object value) {
        this.value = value instanceof String ? (value.equals("XXX") ? value.toString() : ((String)value).toLowerCase()) : value;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StringHashMap)) {
            return false;
        }
        StringHashMap object = (StringHashMap)obj;
        if (this.hasEmptyValue != object.hasEmptyValue) {
            return false;
        }
        if (this.keyToValue == null ? object.keyToValue != null : !((Object)this.keyToValue).equals(object.keyToValue)) {
            return false;
        }
        if (this.keyToValue == null ? object.keyToValue != null : !((Object)this.valueToKey).equals(object.valueToKey)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Iterator<String> iterator() {
        if (this.keyToValue == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>(this.keyToValue.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.keyToValue.get(this.value) == null) {
            return "";
        }
        return this.keyToValue.get(this.value);
    }

    @Override
    protected String getTextEncodingCharSet() {
        return "ISO-8859-1";
    }
}

