/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.asf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.asf.AsfTagCoverField;
import org.jaudiotagger.tag.asf.AsfTagField;
import org.jaudiotagger.tag.asf.AsfTagTextField;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsfTag
extends AbstractTag {
    public static final Set<AsfFieldKey> COMMON_FIELDS;
    private static final EnumMap<FieldKey, AsfFieldKey> TAGFIELD_TO_ASFFIELD;
    private final boolean copyFields;

    public AsfTag() {
        this(false);
    }

    public AsfTag(boolean copy) {
        this.copyFields = copy;
    }

    public AsfTag(Tag source, boolean copy) throws UnsupportedEncodingException {
        this(copy);
        this.copyFrom(source);
    }

    @Override
    public void addField(TagField field) {
        if (this.isValidField(field)) {
            if (AsfFieldKey.isMultiValued(field.getId())) {
                super.addField(this.copyFrom(field));
            } else {
                super.setField(this.copyFrom(field));
            }
        }
    }

    public void addCopyright(String copyRight) {
        this.addField(this.createCopyrightField(copyRight));
    }

    public void addRating(String rating) {
        this.addField(this.createRatingField(rating));
    }

    private void copyFrom(Tag source) {
        Iterator<TagField> fieldIterator = source.getFields();
        while (fieldIterator.hasNext()) {
            TagField copy = this.copyFrom(fieldIterator.next());
            if (copy == null) continue;
            super.addField(copy);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TagField copyFrom(TagField source) {
        if (!this.isCopyingFields()) return source;
        if (source instanceof AsfTagField) {
            try {
                return (TagField)((AsfTagField)source).clone();
            }
            catch (CloneNotSupportedException e) {
                return new AsfTagField(((AsfTagField)source).getDescriptor());
            }
        }
        if (!(source instanceof TagTextField)) throw new RuntimeException("Unknown Asf Tag Field class:" + source.getClass());
        String content = ((TagTextField)source).getContent();
        return new AsfTagTextField(source.getId(), content);
    }

    @Override
    public AsfTagCoverField createField(Artwork artwork) {
        return new AsfTagCoverField(artwork.getBinaryData(), artwork.getPictureType(), artwork.getDescription(), artwork.getMimeType());
    }

    public AsfTagCoverField createArtworkField(byte[] data) {
        return new AsfTagCoverField(data, PictureTypes.DEFAULT_ID, null, null);
    }

    public AsfTagTextField createCopyrightField(String content) {
        return new AsfTagTextField(AsfFieldKey.COPYRIGHT, content);
    }

    public AsfTagTextField createRatingField(String content) {
        return new AsfTagTextField(AsfFieldKey.RATING, content);
    }

    public AsfTagTextField createField(AsfFieldKey asfFieldKey, String value) {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (asfFieldKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        switch (asfFieldKey) {
            case COVER_ART: {
                throw new UnsupportedOperationException("Cover Art cannot be created using this method");
            }
            case BANNER_IMAGE: {
                throw new UnsupportedOperationException("Banner Image cannot be created using this method");
            }
        }
        return new AsfTagTextField(asfFieldKey.getFieldName(), value);
    }

    @Override
    public AsfTagTextField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (genericKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        AsfFieldKey asfFieldKey = TAGFIELD_TO_ASFFIELD.get((Object)genericKey);
        if (asfFieldKey == null) {
            throw new KeyNotFoundException("No ASF fieldkey for " + genericKey.toString());
        }
        return this.createField(asfFieldKey, value);
    }

    public void deleteField(AsfFieldKey fieldKey) {
        super.deleteField(fieldKey.getFieldName());
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(TAGFIELD_TO_ASFFIELD.get((Object)fieldKey).getFieldName());
    }

    @Override
    public List<TagField> getFields(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(TAGFIELD_TO_ASFFIELD.get((Object)fieldKey).getFieldName());
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> coverartList = this.getFields(FieldKey.COVER_ART);
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(coverartList.size());
        for (TagField next : coverartList) {
            AsfTagCoverField coverArt = (AsfTagCoverField)next;
            Artwork artwork = new Artwork();
            artwork.setBinaryData(coverArt.getRawImageData());
            artwork.setMimeType(coverArt.getMimeType());
            artwork.setDescription(coverArt.getDescription());
            artwork.setPictureType(coverArt.getPictureType());
            artworkList.add(artwork);
        }
        return artworkList;
    }

    public Iterator<AsfTagField> getAsfFields() {
        if (!this.isCopyingFields()) {
            throw new IllegalStateException("Since the field conversion is not enabled, this method cannot be executed");
        }
        return new AsfFieldIterator(this.getFields());
    }

    public List<TagField> getCopyright() {
        return this.get(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(TAGFIELD_TO_ASFFIELD.get((Object)genericKey).getFieldName());
    }

    public String getFirstCopyright() {
        return this.getFirst(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    @Override
    public AsfTagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return (AsfTagField)super.getFirstField(TAGFIELD_TO_ASFFIELD.get((Object)genericKey).getFieldName());
    }

    public String getFirstRating() {
        return this.getFirst(AsfFieldKey.RATING.getFieldName());
    }

    public List<TagField> getRating() {
        return this.get(AsfFieldKey.RATING.getFieldName());
    }

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return AsfHeader.ASF_CHARSET.name().equals(enc);
    }

    public boolean isCopyingFields() {
        return this.copyFields;
    }

    private boolean isValidField(TagField field) {
        if (field == null) {
            return false;
        }
        if (!(field instanceof AsfTagField)) {
            return false;
        }
        return !field.isEmpty();
    }

    @Override
    public void setField(TagField field) {
        if (this.isValidField(field)) {
            super.setField(this.copyFrom(field));
        }
    }

    public void setCopyright(String Copyright) {
        this.setField(this.createCopyrightField(Copyright));
    }

    public void setRating(String rating) {
        this.setField(this.createRatingField(rating));
    }

    static {
        TAGFIELD_TO_ASFFIELD = new EnumMap(FieldKey.class);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ARTIST, AsfFieldKey.AUTHOR);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ALBUM, AsfFieldKey.ALBUM);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.TITLE, AsfFieldKey.TITLE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.TRACK, AsfFieldKey.TRACK);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.YEAR, AsfFieldKey.YEAR);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.GENRE, AsfFieldKey.GENRE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.COMMENT, AsfFieldKey.DESCRIPTION);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ALBUM_ARTIST, AsfFieldKey.ALBUM_ARTIST);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.COMPOSER, AsfFieldKey.COMPOSER);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.GROUPING, AsfFieldKey.GROUPING);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.DISC_NO, AsfFieldKey.DISC_NO);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.BPM, AsfFieldKey.BPM);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ENCODER, AsfFieldKey.ENCODER);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_ARTISTID, AsfFieldKey.MUSICBRAINZ_ARTISTID);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_RELEASEID, AsfFieldKey.MUSICBRAINZ_RELEASEID);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_RELEASEARTISTID, AsfFieldKey.MUSICBRAINZ_RELEASEARTISTID);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_TRACK_ID, AsfFieldKey.MUSICBRAINZ_TRACK_ID);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_DISC_ID, AsfFieldKey.MUSICBRAINZ_DISC_ID);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICIP_ID, AsfFieldKey.MUSICIP_ID);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.AMAZON_ID, AsfFieldKey.AMAZON_ID);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_RELEASE_STATUS, AsfFieldKey.MUSICBRAINZ_RELEASE_STATUS);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_RELEASE_TYPE, AsfFieldKey.MUSICBRAINZ_RELEASE_TYPE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MUSICBRAINZ_RELEASE_COUNTRY, AsfFieldKey.MUSICBRAINZ_RELEASE_COUNTRY);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.LYRICS, AsfFieldKey.LYRICS);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.IS_COMPILATION, AsfFieldKey.IS_COMPILATION);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ARTIST_SORT, AsfFieldKey.ARTIST_SORT);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ALBUM_ARTIST_SORT, AsfFieldKey.ALBUM_ARTIST_SORT);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ALBUM_SORT, AsfFieldKey.ALBUM_SORT);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.TITLE_SORT, AsfFieldKey.TITLE_SORT);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.COMPOSER_SORT, AsfFieldKey.COMPOSER_SORT);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.COVER_ART, AsfFieldKey.COVER_ART);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.ISRC, AsfFieldKey.ISRC);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.CATALOG_NO, AsfFieldKey.CATALOG_NO);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.BARCODE, AsfFieldKey.BARCODE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.RECORD_LABEL, AsfFieldKey.RECORD_LABEL);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.LYRICIST, AsfFieldKey.LYRICIST);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.CONDUCTOR, AsfFieldKey.CONDUCTOR);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.REMIXER, AsfFieldKey.REMIXER);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MOOD, AsfFieldKey.MOOD);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.MEDIA, AsfFieldKey.MEDIA);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.URL_OFFICIAL_RELEASE_SITE, AsfFieldKey.URL_OFFICIAL_RELEASE_SITE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.URL_DISCOGS_RELEASE_SITE, AsfFieldKey.URL_DISCOGS_RELEASE_SITE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.URL_WIKIPEDIA_RELEASE_SITE, AsfFieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.URL_OFFICIAL_ARTIST_SITE, AsfFieldKey.URL_OFFICIAL_ARTIST_SITE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.URL_DISCOGS_ARTIST_SITE, AsfFieldKey.URL_DISCOGS_ARTIST_SITE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.URL_WIKIPEDIA_ARTIST_SITE, AsfFieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.LANGUAGE, AsfFieldKey.LANGUAGE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.KEY, AsfFieldKey.INITIAL_KEY);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.URL_LYRICS_SITE, AsfFieldKey.URL_LYRICS_SITE);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.TRACK_TOTAL, AsfFieldKey.TRACK_TOTAL);
        TAGFIELD_TO_ASFFIELD.put(FieldKey.DISC_TOTAL, AsfFieldKey.DISC_TOTAL);
        COMMON_FIELDS = new HashSet<AsfFieldKey>();
        COMMON_FIELDS.add(AsfFieldKey.ALBUM);
        COMMON_FIELDS.add(AsfFieldKey.AUTHOR);
        COMMON_FIELDS.add(AsfFieldKey.DESCRIPTION);
        COMMON_FIELDS.add(AsfFieldKey.GENRE);
        COMMON_FIELDS.add(AsfFieldKey.TITLE);
        COMMON_FIELDS.add(AsfFieldKey.TRACK);
        COMMON_FIELDS.add(AsfFieldKey.YEAR);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsfFieldIterator
    implements Iterator<AsfTagField> {
        private final Iterator<TagField> fieldIterator;

        public AsfFieldIterator(Iterator<TagField> iterator) {
            assert (iterator != null);
            this.fieldIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.fieldIterator.hasNext();
        }

        @Override
        public AsfTagField next() {
            return (AsfTagField)this.fieldIterator.next();
        }

        @Override
        public void remove() {
            this.fieldIterator.remove();
        }
    }
}

