/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.html.HtmlTag;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.HtmlPathElement;
import org.zwobble.mammoth.internal.styles.HtmlPathElements;
import org.zwobble.mammoth.internal.styles.parsing.TokenIterator;
import org.zwobble.mammoth.internal.styles.parsing.TokenParser;
import org.zwobble.mammoth.internal.styles.parsing.TokenType;
import org.zwobble.mammoth.internal.util.Maps;

public class HtmlPathParser {
    public static HtmlPath parse(TokenIterator<TokenType> tokens) {
        if (tokens.trySkip(TokenType.SYMBOL, "!")) {
            return HtmlPath.IGNORE;
        }
        return HtmlPathParser.parseHtmlPathElements(tokens);
    }

    private static HtmlPath parseHtmlPathElements(TokenIterator<TokenType> tokens) {
        ArrayList<HtmlPathElement> elements = new ArrayList<HtmlPathElement>();
        if (tokens.peekTokenType() == TokenType.IDENTIFIER) {
            HtmlPathElement element = HtmlPathParser.parseElement(tokens);
            elements.add(element);
            while (tokens.peekTokenType() == TokenType.WHITESPACE && tokens.isNext(1, TokenType.SYMBOL, ">")) {
                tokens.skip(TokenType.WHITESPACE);
                tokens.skip(TokenType.SYMBOL, ">");
                tokens.skip(TokenType.WHITESPACE);
                elements.add(HtmlPathParser.parseElement(tokens));
            }
        }
        return new HtmlPathElements(elements);
    }

    private static HtmlPathElement parseElement(TokenIterator<TokenType> tokens) {
        List<String> tagNames = HtmlPathParser.parseTagNames(tokens);
        List<String> classNames = HtmlPathParser.parseClassNames(tokens);
        Map<String, String> attributes = classNames.isEmpty() ? Maps.map() : Maps.map("class", String.join((CharSequence)" ", classNames));
        boolean isFresh = HtmlPathParser.parseIsFresh(tokens);
        String separator = HtmlPathParser.parseSeparator(tokens);
        return new HtmlPathElement(new HtmlTag(tagNames, attributes, !isFresh, separator));
    }

    private static List<String> parseTagNames(TokenIterator<TokenType> tokens) {
        ArrayList<String> tagNames = new ArrayList<String>();
        tagNames.add(TokenParser.parseIdentifier(tokens));
        while (tokens.trySkip(TokenType.SYMBOL, "|")) {
            tagNames.add(TokenParser.parseIdentifier(tokens));
        }
        return tagNames;
    }

    private static List<String> parseClassNames(TokenIterator<TokenType> tokens) {
        Optional<String> className;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((className = TokenParser.parseClassName(tokens)).isPresent()) {
            classNames.add(className.get());
        }
        return classNames;
    }

    private static boolean parseIsFresh(TokenIterator<TokenType> tokens) {
        return tokens.tryParse(() -> {
            tokens.skip(TokenType.SYMBOL, ":");
            tokens.skip(TokenType.IDENTIFIER, "fresh");
        });
    }

    private static String parseSeparator(TokenIterator<TokenType> tokens) {
        boolean isSeparator = tokens.tryParse(() -> {
            tokens.skip(TokenType.SYMBOL, ":");
            tokens.skip(TokenType.IDENTIFIER, "separator");
        });
        if (isSeparator) {
            tokens.skip(TokenType.SYMBOL, "(");
            String value = TokenParser.parseString(tokens);
            tokens.skip(TokenType.SYMBOL, ")");
            return value;
        }
        return "";
    }
}

