/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Break;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.styles.BreakMatcher;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.ParagraphMatcher;
import org.zwobble.mammoth.internal.styles.RunMatcher;
import org.zwobble.mammoth.internal.styles.StyleMap;
import org.zwobble.mammoth.internal.styles.StyleMapping;
import org.zwobble.mammoth.internal.styles.TableMatcher;

public class StyleMapBuilder {
    private Optional<HtmlPath> underline;
    private Optional<HtmlPath> strikethrough;
    private Optional<HtmlPath> smallCaps;
    private Optional<HtmlPath> bold;
    private Optional<HtmlPath> italic;
    private Optional<HtmlPath> commentReference;
    private final List<StyleMapping<Paragraph>> paragraphStyles = new ArrayList<StyleMapping<Paragraph>>();
    private final List<StyleMapping<Run>> runStyles = new ArrayList<StyleMapping<Run>>();
    private final List<StyleMapping<Table>> tableStyles = new ArrayList<StyleMapping<Table>>();
    private final List<StyleMapping<Break>> breakStyles = new ArrayList<StyleMapping<Break>>();

    public StyleMapBuilder() {
        this.bold = Optional.empty();
        this.underline = Optional.empty();
        this.strikethrough = Optional.empty();
        this.smallCaps = Optional.empty();
        this.italic = Optional.empty();
        this.commentReference = Optional.empty();
    }

    public StyleMapBuilder bold(HtmlPath path) {
        this.bold = Optional.of(path);
        return this;
    }

    public StyleMapBuilder italic(HtmlPath path) {
        this.italic = Optional.of(path);
        return this;
    }

    public StyleMapBuilder underline(HtmlPath path) {
        this.underline = Optional.of(path);
        return this;
    }

    public StyleMapBuilder strikethrough(HtmlPath path) {
        this.strikethrough = Optional.of(path);
        return this;
    }

    public StyleMapBuilder smallCaps(HtmlPath path) {
        this.smallCaps = Optional.of(path);
        return this;
    }

    public StyleMapBuilder commentReference(HtmlPath path) {
        this.commentReference = Optional.of(path);
        return this;
    }

    public StyleMapBuilder mapParagraph(ParagraphMatcher matcher, HtmlPath path) {
        this.paragraphStyles.add(new StyleMapping<Paragraph>(matcher, path));
        return this;
    }

    public StyleMapBuilder mapRun(RunMatcher matcher, HtmlPath path) {
        this.runStyles.add(new StyleMapping<Run>(matcher, path));
        return this;
    }

    public StyleMapBuilder mapTable(TableMatcher matcher, HtmlPath path) {
        this.tableStyles.add(new StyleMapping<Table>(matcher, path));
        return this;
    }

    public StyleMapBuilder mapBreak(BreakMatcher matcher, HtmlPath path) {
        this.breakStyles.add(new StyleMapping<Break>(matcher, path));
        return this;
    }

    public StyleMap build() {
        return new StyleMap(this.bold, this.italic, this.underline, this.strikethrough, this.smallCaps, this.commentReference, this.paragraphStyles, this.runStyles, this.tableStyles, this.breakStyles);
    }
}

