/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.NumberingLevel;
import org.zwobble.mammoth.internal.docx.Numbering;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlElementList;

public class NumberingXml {
    public static Numbering readNumberingXmlElement(XmlElement element, Styles styles) {
        Map<String, Numbering.AbstractNum> abstractNums = NumberingXml.readAbstractNums(element.findChildren("w:abstractNum"));
        Map<String, Numbering.Num> nums = NumberingXml.readNums(element.findChildren("w:num"));
        return new Numbering(abstractNums, nums, styles);
    }

    private static Map<String, Numbering.AbstractNum> readAbstractNums(XmlElementList children) {
        return Maps.toMap(children, NumberingXml::readAbstractNum);
    }

    private static Map.Entry<String, Numbering.AbstractNum> readAbstractNum(XmlElement element) {
        String abstractNumId = element.getAttribute("w:abstractNumId");
        Numbering.AbstractNum abstractNum = new Numbering.AbstractNum(NumberingXml.readAbstractNumLevels(element), element.findChildOrEmpty("w:numStyleLink").getAttributeOrNone("w:val"));
        return Maps.entry(abstractNumId, abstractNum);
    }

    private static Map<String, NumberingLevel> readAbstractNumLevels(XmlElement element) {
        return Maps.toMap(element.findChildren("w:lvl"), NumberingXml::readAbstractNumLevel);
    }

    private static Map.Entry<String, NumberingLevel> readAbstractNumLevel(XmlElement element) {
        String levelIndex = element.getAttribute("w:ilvl");
        Optional<String> numFmt = element.findChildOrEmpty("w:numFmt").getAttributeOrNone("w:val");
        boolean isOrdered = !numFmt.equals(Optional.of("bullet"));
        return Maps.entry(levelIndex, new NumberingLevel(levelIndex, isOrdered));
    }

    private static Map<String, Numbering.Num> readNums(XmlElementList numElements) {
        return Maps.toMap(numElements, NumberingXml::readNum);
    }

    private static Map.Entry<String, Numbering.Num> readNum(XmlElement numElement) {
        String numId = numElement.getAttribute("w:numId");
        Optional<String> abstractNumId = numElement.findChildOrEmpty("w:abstractNumId").getAttributeOrNone("w:val");
        return Maps.entry(numId, new Numbering.Num(abstractNumId));
    }
}

