/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.NumberingLevel;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.util.Maps;

public class Numbering {
    public static final Numbering EMPTY = new Numbering(Maps.map(), Maps.map(), Styles.EMPTY);
    private final Map<String, AbstractNum> abstractNums;
    private final Map<String, Num> nums;
    private final Styles styles;

    public Numbering(Map<String, AbstractNum> abstractNums, Map<String, Num> nums, Styles styles) {
        this.abstractNums = abstractNums;
        this.nums = nums;
        this.styles = styles;
    }

    public Optional<NumberingLevel> findLevel(String numId, String level) {
        return Maps.lookup(this.nums, numId).flatMap(num -> ((Num)num).abstractNumId).flatMap(abstractNumId -> Maps.lookup(this.abstractNums, abstractNumId)).flatMap(abstractNum -> {
            if (((AbstractNum)abstractNum).numStyleLink.isPresent()) {
                return ((AbstractNum)abstractNum).numStyleLink.flatMap(numStyleLink -> this.styles.findNumberingStyleById((String)numStyleLink)).flatMap(style -> style.getNumId()).flatMap(linkedNumId -> this.findLevel((String)linkedNumId, level));
            }
            return Maps.lookup(((AbstractNum)abstractNum).levels, level);
        });
    }

    public static class Num {
        private final Optional<String> abstractNumId;

        public Num(Optional<String> abstractNumId) {
            this.abstractNumId = abstractNumId;
        }
    }

    public static class AbstractNum {
        private final Map<String, NumberingLevel> levels;
        private final Optional<String> numStyleLink;

        public AbstractNum(Map<String, NumberingLevel> levels, Optional<String> numStyleLink) {
            this.levels = levels;
            this.numStyleLink = numStyleLink;
        }
    }
}

