/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.zwobble.mammoth.internal.archives.Archive;
import org.zwobble.mammoth.internal.archives.ZipPaths;
import org.zwobble.mammoth.internal.documents.Comment;
import org.zwobble.mammoth.internal.documents.Document;
import org.zwobble.mammoth.internal.documents.Notes;
import org.zwobble.mammoth.internal.docx.BodyXmlReader;
import org.zwobble.mammoth.internal.docx.CommentXmlReader;
import org.zwobble.mammoth.internal.docx.ContentTypes;
import org.zwobble.mammoth.internal.docx.ContentTypesXml;
import org.zwobble.mammoth.internal.docx.DocumentXmlReader;
import org.zwobble.mammoth.internal.docx.FileReader;
import org.zwobble.mammoth.internal.docx.NotesXmlReader;
import org.zwobble.mammoth.internal.docx.Numbering;
import org.zwobble.mammoth.internal.docx.NumberingXml;
import org.zwobble.mammoth.internal.docx.OfficeXml;
import org.zwobble.mammoth.internal.docx.PathRelativeFileReader;
import org.zwobble.mammoth.internal.docx.Relationships;
import org.zwobble.mammoth.internal.docx.RelationshipsXml;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.docx.StylesXml;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.PassThroughException;
import org.zwobble.mammoth.internal.util.Strings;
import org.zwobble.mammoth.internal.xml.XmlElement;

public class DocumentReader {
    public static InternalResult<Document> readDocument(Optional<Path> path, Archive zipFile) {
        PartPaths partPaths = DocumentReader.findPartPaths(zipFile);
        Styles styles = DocumentReader.readStyles(zipFile, partPaths);
        Numbering numbering = DocumentReader.readNumbering(zipFile, partPaths, styles);
        ContentTypes contentTypes = DocumentReader.readContentTypes(zipFile);
        PathRelativeFileReader fileReader = new PathRelativeFileReader(path);
        PartWithBodyReader partReader = new PartWithBodyReader(zipFile, contentTypes, fileReader, numbering, styles);
        return InternalResult.flatMap(DocumentReader.readNotes(partReader, partPaths), DocumentReader.readComments(partReader, partPaths), (notes, comments) -> partReader.readPart(partPaths.getMainDocument(), (element, bodyReader) -> new DocumentXmlReader((BodyXmlReader)bodyReader, (Notes)notes, (List<Comment>)comments).readElement((XmlElement)element), Optional.empty()));
    }

    public static PartPaths findPartPaths(Archive archive) {
        Relationships packageRelationships = DocumentReader.readPackageRelationships(archive);
        String documentFilename = DocumentReader.findDocumentFilename(archive, packageRelationships);
        Relationships documentRelationships = DocumentReader.readRelationships(archive, DocumentReader.findRelationshipsPathFor(documentFilename));
        Function<String, String> find = name -> DocumentReader.findPartPath(archive, documentRelationships, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/" + name, ZipPaths.splitPath(documentFilename).getDirname(), "word/" + name + ".xml");
        return new PartPaths(documentFilename, find.apply("comments"), find.apply("endnotes"), find.apply("footnotes"), find.apply("numbering"), find.apply("styles"));
    }

    private static Relationships readPackageRelationships(Archive archive) {
        return DocumentReader.readRelationships(archive, "_rels/.rels");
    }

    private static String findDocumentFilename(Archive archive, Relationships packageRelationships) {
        String officeDocumentType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
        String mainDocumentPath = DocumentReader.findPartPath(archive, packageRelationships, officeDocumentType, "", "word/document.xml");
        if (archive.exists(mainDocumentPath)) {
            return mainDocumentPath;
        }
        throw new PassThroughException(new IOException("Could not find main document part. Are you sure this is a valid .docx file?"));
    }

    private static String findPartPath(Archive archive, Relationships relationships, String relationshipType, String basePath, String fallbackPath) {
        List<String> targets = Lists.eagerMap(relationships.findTargetsByType(relationshipType), target -> Strings.trimLeft(ZipPaths.joinPath(basePath, target), '/'));
        List<String> validTargets = Lists.eagerFilter(targets, archive::exists);
        return Lists.tryGetFirst(validTargets).orElse(fallbackPath);
    }

    private static InternalResult<List<Comment>> readComments(PartWithBodyReader partReader, PartPaths partPaths) {
        return partReader.readPart(partPaths.getComments(), (root, bodyReader) -> new CommentXmlReader((BodyXmlReader)bodyReader).readElement((XmlElement)root), Optional.of(InternalResult.success(Lists.list())));
    }

    private static InternalResult<Notes> readNotes(PartWithBodyReader partReader, PartPaths partPaths) {
        return InternalResult.map(partReader.readPart(partPaths.getFootnotes(), (root, bodyReader) -> NotesXmlReader.footnote(bodyReader).readElement((XmlElement)root), Optional.of(InternalResult.success(Lists.list()))), partReader.readPart(partPaths.getEndnotes(), (root, bodyReader) -> NotesXmlReader.endnote(bodyReader).readElement((XmlElement)root), Optional.of(InternalResult.success(Lists.list()))), Lists::eagerConcat).map(Notes::new);
    }

    private static Styles readStyles(Archive file, PartPaths partPaths) {
        return DocumentReader.tryParseOfficeXml(file, partPaths.getStyles()).map(StylesXml::readStylesXmlElement).orElse(Styles.EMPTY);
    }

    private static Numbering readNumbering(Archive file, PartPaths partPaths, Styles styles) {
        return DocumentReader.tryParseOfficeXml(file, partPaths.getNumbering()).map(element -> NumberingXml.readNumberingXmlElement(element, styles)).orElse(Numbering.EMPTY);
    }

    private static ContentTypes readContentTypes(Archive file) {
        return DocumentReader.tryParseOfficeXml(file, "[Content_Types].xml").map(ContentTypesXml::readContentTypesXmlElement).orElse(ContentTypes.DEFAULT);
    }

    private static Relationships readRelationships(Archive zipFile, String name) {
        return DocumentReader.tryParseOfficeXml(zipFile, name).map(RelationshipsXml::readRelationshipsXmlElement).orElse(Relationships.EMPTY);
    }

    private static String findRelationshipsPathFor(String name) {
        ZipPaths.SplitPath parts = ZipPaths.splitPath(name);
        return ZipPaths.joinPath(parts.getDirname(), "_rels", parts.getBasename() + ".rels");
    }

    private static Optional<XmlElement> tryParseOfficeXml(Archive zipFile, String name) {
        return PassThroughException.wrap(() -> zipFile.tryGetInputStream(name).map(OfficeXml::parseXml));
    }

    private static XmlElement parseOfficeXml(Archive zipFile, String name) {
        return DocumentReader.tryParseOfficeXml(zipFile, name).orElseThrow(() -> new PassThroughException(new IOException("Missing entry in file: " + name)));
    }

    public static class PartPaths {
        private final String mainDocument;
        private final String comments;
        private final String endnotes;
        private final String footnotes;
        private final String numbering;
        private final String styles;

        public PartPaths(String mainDocument, String comments, String endnotes, String footnotes, String numbering, String styles) {
            this.mainDocument = mainDocument;
            this.comments = comments;
            this.endnotes = endnotes;
            this.footnotes = footnotes;
            this.numbering = numbering;
            this.styles = styles;
        }

        public String getMainDocument() {
            return this.mainDocument;
        }

        public String getComments() {
            return this.comments;
        }

        public String getEndnotes() {
            return this.endnotes;
        }

        public String getFootnotes() {
            return this.footnotes;
        }

        public String getNumbering() {
            return this.numbering;
        }

        public String getStyles() {
            return this.styles;
        }
    }

    private static class PartWithBodyReader {
        private final Archive zipFile;
        private final ContentTypes contentTypes;
        private final FileReader fileReader;
        private final Numbering numbering;
        private final Styles styles;

        public PartWithBodyReader(Archive zipFile, ContentTypes contentTypes, FileReader fileReader, Numbering numbering, Styles styles) {
            this.zipFile = zipFile;
            this.contentTypes = contentTypes;
            this.fileReader = fileReader;
            this.numbering = numbering;
            this.styles = styles;
        }

        <T> T readPart(String name, BiFunction<XmlElement, BodyXmlReader, T> readPart, Optional<T> defaultValue) {
            Relationships relationships = DocumentReader.readRelationships(this.zipFile, DocumentReader.findRelationshipsPathFor(name));
            BodyXmlReader bodyReader = new BodyXmlReader(this.styles, this.numbering, relationships, this.contentTypes, this.zipFile, this.fileReader);
            if (defaultValue.isPresent()) {
                return (T)DocumentReader.tryParseOfficeXml(this.zipFile, name).map(root -> readPart.apply((XmlElement)root, bodyReader)).orElse(defaultValue.get());
            }
            return readPart.apply(DocumentReader.parseOfficeXml(this.zipFile, name), bodyReader);
        }
    }
}

