/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.Map;
import org.zwobble.mammoth.internal.docx.ContentTypes;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.util.Strings;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlElementList;

public class ContentTypesXml {
    public static ContentTypes readContentTypesXmlElement(XmlElement element) {
        return new ContentTypes(ContentTypesXml.readDefaults(element.findChildren("content-types:Default")), ContentTypesXml.readOverrides(element.findChildren("content-types:Override")));
    }

    private static Map<String, String> readDefaults(XmlElementList children) {
        return Maps.toMap(children, ContentTypesXml::readDefault);
    }

    private static Map.Entry<String, String> readDefault(XmlElement element) {
        return Maps.entry(element.getAttribute("Extension"), element.getAttribute("ContentType"));
    }

    private static Map<String, String> readOverrides(XmlElementList children) {
        return Maps.toMap(children, ContentTypesXml::readOverride);
    }

    private static Map.Entry<String, String> readOverride(XmlElement element) {
        return Maps.entry(Strings.trimLeft(element.getAttribute("PartName"), '/'), element.getAttribute("ContentType"));
    }
}

