/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.util.Paths;

public class ContentTypes {
    public static final ContentTypes DEFAULT = new ContentTypes(Maps.map(), Maps.map());
    private static final Map<String, String> imageExtensions = Maps.builder().put("png", "png").put("gif", "gif").put("jpeg", "jpeg").put("jpg", "jpeg").put("bmp", "bmp").put("tif", "tiff").put("tiff", "tiff").build();
    private final Map<String, String> extensionDefaults;
    private final Map<String, String> overrides;

    public ContentTypes(Map<String, String> extensionDefaults, Map<String, String> overrides) {
        this.extensionDefaults = extensionDefaults;
        this.overrides = overrides;
    }

    public Optional<String> findContentType(String path) {
        if (this.overrides.containsKey(path)) {
            return Maps.lookup(this.overrides, path);
        }
        String extension = Paths.getExtension(path);
        if (this.extensionDefaults.containsKey(extension)) {
            return Maps.lookup(this.extensionDefaults, extension);
        }
        return Maps.lookup(imageExtensions, extension.toLowerCase()).map(imageType -> "image/" + imageType);
    }
}

