/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Comment;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.docx.BodyXmlReader;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.xml.XmlElement;

public class CommentXmlReader {
    private final BodyXmlReader bodyReader;

    public CommentXmlReader(BodyXmlReader bodyReader) {
        this.bodyReader = bodyReader;
    }

    public InternalResult<List<Comment>> readElement(XmlElement element) {
        return InternalResult.flatMap(element.findChildren("w:comment"), this::readCommentElement);
    }

    private InternalResult<Comment> readCommentElement(XmlElement element) {
        String commentId = element.getAttribute("w:id");
        return this.bodyReader.readElements(element.getChildren()).toResult().map(children -> new Comment(commentId, (List<DocumentElement>)children, this.readOptionalAttribute(element, "w:author"), this.readOptionalAttribute(element, "w:initials")));
    }

    private Optional<String> readOptionalAttribute(XmlElement element, String name) {
        String value = element.getAttributeOrNone(name).orElse("").trim();
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }
}

