/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.documents;

import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;
import org.zwobble.mammoth.internal.documents.HasChildren;

public class Hyperlink
implements DocumentElement,
HasChildren {
    private final Optional<String> href;
    private final Optional<String> anchor;
    private final Optional<String> targetFrame;
    private final List<DocumentElement> children;

    public static Hyperlink href(String href, Optional<String> targetFrame, List<DocumentElement> children) {
        return new Hyperlink(Optional.of(href), Optional.empty(), targetFrame, children);
    }

    public static Hyperlink anchor(String anchor, Optional<String> targetFrame, List<DocumentElement> children) {
        return new Hyperlink(Optional.empty(), Optional.of(anchor), targetFrame, children);
    }

    public Hyperlink(Optional<String> href, Optional<String> anchor, Optional<String> targetFrame, List<DocumentElement> children) {
        this.href = href;
        this.anchor = anchor;
        this.targetFrame = targetFrame;
        this.children = children;
    }

    public Optional<String> getHref() {
        return this.href;
    }

    public Optional<String> getAnchor() {
        return this.anchor;
    }

    public Optional<String> getTargetFrame() {
        return this.targetFrame;
    }

    @Override
    public List<DocumentElement> getChildren() {
        return this.children;
    }

    @Override
    public <T, U> T accept(DocumentElementVisitor<T, U> visitor, U context) {
        return visitor.visit(this, context);
    }
}

