/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations.admin;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.AdministrationOperations;
import org.wildfly.extras.creaper.core.online.operations.admin.CommonRestartOperation;
import org.wildfly.extras.creaper.core.online.operations.admin.RestartOperation;
import org.wildfly.extras.creaper.core.online.operations.admin.ServerState;

final class StandaloneAdministrationOperations
implements AdministrationOperations {
    private final OnlineManagementClient client;
    private final Operations ops;
    private final int timeoutInSeconds;

    public StandaloneAdministrationOperations(OnlineManagementClient client, int timeoutInSeconds) {
        this.client = client;
        this.ops = new Operations(client);
        this.timeoutInSeconds = timeoutInSeconds;
    }

    @Override
    public boolean isReloadRequired() throws IOException {
        return this.isRestartOperationRequired(CommonRestartOperation.RELOAD);
    }

    @Override
    public void reload() throws IOException, InterruptedException, TimeoutException {
        this.performRestartOperation(CommonRestartOperation.RELOAD);
    }

    @Override
    public boolean reloadIfRequired() throws IOException, InterruptedException, TimeoutException {
        if (this.isRestartOperationRequired(CommonRestartOperation.RELOAD)) {
            this.reload();
            return true;
        }
        return false;
    }

    @Override
    public boolean isRestartRequired() throws IOException {
        return this.isRestartOperationRequired(CommonRestartOperation.RESTART);
    }

    @Override
    public void restart() throws IOException, InterruptedException, TimeoutException {
        this.performRestartOperation(CommonRestartOperation.RESTART);
    }

    @Override
    public boolean restartIfRequired() throws IOException, InterruptedException, TimeoutException {
        if (this.isRestartOperationRequired(CommonRestartOperation.RESTART)) {
            this.restart();
            return true;
        }
        return false;
    }

    @Override
    public void shutdown(int timeoutInSeconds) throws IOException {
        if (timeoutInSeconds == 0) {
            this.ops.invoke("shutdown", Address.root());
        } else {
            this.ops.invoke("shutdown", Address.root(), Values.of("timeout", timeoutInSeconds));
        }
    }

    @Override
    public void waitUntilRunning() throws InterruptedException, TimeoutException, IOException {
        this.waitUntilServerIsRunning(true);
    }

    void performRestartOperation(RestartOperation restartOperation) throws IOException, InterruptedException, TimeoutException {
        boolean needsToReconnect = false;
        try {
            restartOperation.perform(this.ops, Address.root());
        }
        catch (Throwable e) {
            needsToReconnect = true;
        }
        this.waitUntilServerIsRunning(needsToReconnect);
    }

    private boolean isRestartOperationRequired(CommonRestartOperation restartOperation) throws IOException {
        return restartOperation.isRequired(this.ops.readAttribute(Address.root(), "server-state", new ReadAttributeOption[0]), false);
    }

    private void waitUntilServerIsRunning(boolean reconnect) throws IOException, InterruptedException, TimeoutException {
        Thread.sleep(500L);
        if (reconnect) {
            this.client.reconnect(this.timeoutInSeconds);
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.timeoutInSeconds);
        while (System.currentTimeMillis() < endTime) {
            try {
                if (this.isServerRunning()) {
                    break;
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            Thread.sleep(200L);
        }
        boolean running = false;
        try {
            running = this.isServerRunning();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (!running) {
            throw new TimeoutException("Waiting for server timed out");
        }
    }

    private boolean isServerRunning() throws IOException {
        ModelNodeResult result = this.ops.readAttribute(Address.root(), "server-state", new ReadAttributeOption[0]);
        result.assertDefinedValue();
        return ServerState.isRunning(result.stringValue());
    }
}

