/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations.admin;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.DomainAdministrationOperations;
import org.wildfly.extras.creaper.core.online.operations.admin.RestartOperation;
import org.wildfly.extras.creaper.core.online.operations.admin.StandaloneAdministrationOperations;

public final class ReloadToSnapshot {
    private final OnlineManagementClient client;
    private final String snapshot;
    private final int timeoutInSeconds;

    public ReloadToSnapshot(OnlineManagementClient client, String snapshot) throws IOException {
        this(client, snapshot, 60);
    }

    public ReloadToSnapshot(OnlineManagementClient client, String snapshot, int timeoutInSeconds) throws IOException {
        if (client.version().lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new IllegalStateException("ReloadToSnapshot requires at least WildFly Core 3.");
        }
        this.client = client;
        this.snapshot = snapshot;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public void perform() throws InterruptedException, TimeoutException, IOException {
        if (this.client.options().isStandalone) {
            new StandaloneAdministrationOperations(this.client, this.timeoutInSeconds).performRestartOperation(new ReloadToStandaloneSnapshotRestartOperation(this.snapshot));
        } else {
            this.perform(this.client.options().defaultHost);
        }
    }

    public void perform(String host) throws InterruptedException, TimeoutException, IOException {
        if (!this.client.options().isDomain) {
            throw new IllegalStateException("Asked to reload host '" + host + "' to a snapshot, but the server isn't a domain controller");
        }
        new DomainAdministrationOperations(this.client, this.timeoutInSeconds).performRestartOperation(host, new ReloadToDomainSnapshotRestartOperation(this.snapshot));
    }

    private static final class ReloadToDomainSnapshotRestartOperation
    implements RestartOperation {
        private final String snapshot;

        ReloadToDomainSnapshotRestartOperation(String snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public ModelNodeResult perform(Operations ops, Address address) throws IOException {
            return ops.invoke("reload", address, Values.of("domain-config", this.snapshot));
        }
    }

    private static final class ReloadToStandaloneSnapshotRestartOperation
    implements RestartOperation {
        private final String snapshot;

        ReloadToStandaloneSnapshotRestartOperation(String snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public ModelNodeResult perform(Operations ops, Address address) throws IOException {
            return ops.invoke("reload", address, Values.of("server-config", this.snapshot));
        }
    }
}

