/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations.admin;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.RestartOperation;
import org.wildfly.extras.creaper.core.online.operations.admin.StandaloneAdministrationOperations;

public final class ReloadToOriginal {
    private final OnlineManagementClient client;
    private final int timeoutInSeconds;

    public ReloadToOriginal(OnlineManagementClient client) throws IOException {
        this(client, 60);
    }

    public ReloadToOriginal(OnlineManagementClient client, int timeoutInSeconds) throws IOException {
        if (!client.options().isStandalone) {
            throw new IllegalStateException("ReloadToOriginal is only supported for a standalone server");
        }
        if (client.version().lessThan(ServerVersion.VERSION_1_4_0)) {
            throw new IllegalStateException("ReloadToOriginal requires at least JBoss AS 7.2.0 (EAP 6.1.0)");
        }
        this.client = client;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    private static String commandUsedToStartTheServer(OnlineManagementClient client, String host) throws IOException {
        Address baseAddress = Address.root();
        if (host != null) {
            baseAddress = Address.host(host);
        }
        ModelNodeResult systemProperties = new Operations(client).readAttribute(baseAddress.and("core-service", "platform-mbean").and("type", "runtime"), "system-properties", new ReadAttributeOption[0]);
        systemProperties.assertDefinedValue();
        return systemProperties.value().get("sun.java.command").asString();
    }

    private static void checkReloadToOriginalMakesSense(OnlineManagementClient client, String host) throws IOException {
        if (System.getProperty("creaper.reloadToOriginal.skipCheck") != null) {
            return;
        }
        String command = ReloadToOriginal.commandUsedToStartTheServer(client, host);
        if (client.options().isStandalone && !command.contains("--read-only-server-config")) {
            throw new IllegalStateException("Reloading to original configuration doesn't make sense, the server must be started with --read-only-server-config=standalone*.xml");
        }
        if (client.options().isDomain && !command.contains("--read-only-domain-config") && !command.contains("--read-only-host-config")) {
            throw new IllegalStateException("Reloading to original configuration doesn't make sense, the host contoller must be started with --read-only-domain-config=domain.xml and/or --read-only-host-config=host*.xml");
        }
    }

    public void perform() throws InterruptedException, TimeoutException, IOException {
        ReloadToOriginal.checkReloadToOriginalMakesSense(this.client, null);
        new StandaloneAdministrationOperations(this.client, this.timeoutInSeconds).performRestartOperation(new ReloadToOriginalRestartOperation());
    }

    private static final class ReloadToOriginalRestartOperation
    implements RestartOperation {
        private ReloadToOriginalRestartOperation() {
        }

        @Override
        public ModelNodeResult perform(Operations ops, Address address) throws IOException {
            return ops.invoke("reload", address, Values.of("use-current-server-config", false));
        }
    }
}

