/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.AdministrationOperations;
import org.wildfly.extras.creaper.core.online.operations.admin.CommonRestartOperation;
import org.wildfly.extras.creaper.core.online.operations.admin.RestartOperation;
import org.wildfly.extras.creaper.core.online.operations.admin.ServerState;

final class DomainAdministrationOperations
implements AdministrationOperations {
    private final OnlineManagementClient client;
    private final Operations ops;
    private final int timeoutInSeconds;

    public DomainAdministrationOperations(OnlineManagementClient client, int timeoutInSeconds) {
        this.client = client;
        this.ops = new Operations(client);
        this.timeoutInSeconds = timeoutInSeconds;
    }

    @Override
    public boolean isReloadRequired() throws IOException {
        return this.isRestartOperationRequired(this.client.options().defaultHost, CommonRestartOperation.RELOAD);
    }

    @Override
    public void reload() throws IOException, InterruptedException, TimeoutException {
        this.performRestartOperation(this.client.options().defaultHost, CommonRestartOperation.RELOAD);
    }

    @Override
    public boolean reloadIfRequired() throws IOException, InterruptedException, TimeoutException {
        if (this.isRestartOperationRequired(this.client.options().defaultHost, CommonRestartOperation.RELOAD)) {
            this.reload();
            return true;
        }
        return false;
    }

    @Override
    public boolean isRestartRequired() throws IOException {
        return this.isRestartOperationRequired(this.client.options().defaultHost, CommonRestartOperation.RESTART);
    }

    @Override
    public void restart() throws IOException, InterruptedException, TimeoutException {
        this.performRestartOperation(this.client.options().defaultHost, CommonRestartOperation.RESTART);
    }

    @Override
    public boolean restartIfRequired() throws IOException, InterruptedException, TimeoutException {
        if (this.isRestartOperationRequired(this.client.options().defaultHost, CommonRestartOperation.RESTART)) {
            this.restart();
            return true;
        }
        return false;
    }

    @Override
    public void shutdown(int timeoutInSeconds) throws IOException {
        this.shutdown(this.client.options().defaultHost, timeoutInSeconds);
    }

    void shutdown(String host, int timeoutInSeconds) throws IOException {
        if (timeoutInSeconds == 0) {
            this.ops.invoke("shutdown", Address.host(host));
        } else {
            Batch batch = new Batch();
            for (String server : this.allRunningServers(host)) {
                batch.invoke("stop", Address.host(host).and("server-config", server), Values.of("timeout", timeoutInSeconds));
            }
            batch.invoke("shutdown", Address.host(host));
            this.ops.batch(batch);
        }
    }

    @Override
    public void waitUntilRunning() throws InterruptedException, TimeoutException, IOException {
        this.waitUntilServersAreRunning(this.client.options().defaultHost, null, true);
    }

    void performRestartOperation(String host, RestartOperation restartOperation) throws IOException, TimeoutException, InterruptedException {
        List<String> allServers = this.allRunningServers(host);
        boolean needsToReconnect = false;
        try {
            restartOperation.perform(this.ops, Address.host(host));
        }
        catch (Throwable e) {
            needsToReconnect = true;
        }
        this.waitUntilServersAreRunning(host, allServers, needsToReconnect);
    }

    boolean isRestartOperationRequired(String host, CommonRestartOperation restartOperation) throws IOException {
        List<String> allServers = this.allRunningServers(host);
        Batch batch = new Batch();
        batch.readAttribute(Address.host(host), "host-state", new ReadAttributeOption[0]);
        for (String server : allServers) {
            batch.readAttribute(Address.host(host).and("server", server), "server-state", new ReadAttributeOption[0]);
        }
        ModelNodeResult result = this.ops.batch(batch);
        result.assertDefinedValue();
        int counter = 0;
        for (ModelNodeResult stepResult : result.forAllBatchSteps()) {
            if (restartOperation.isRequired(stepResult, counter > 0)) {
                return true;
            }
            ++counter;
        }
        return false;
    }

    List<String> allRunningServers(String host) throws IOException {
        ModelNodeResult result = this.ops.readChildrenNames(Address.host(host), "server");
        result.assertDefinedValue();
        List<String> servers = result.stringListValue();
        ArrayList<String> startedServers = new ArrayList<String>();
        for (String server : servers) {
            ModelNodeResult serverStatus = this.ops.readAttribute(Address.host(host).and("server-config", server), "status", new ReadAttributeOption[0]);
            serverStatus.assertDefinedValue();
            if (!"STARTED".equals(serverStatus.stringValue())) continue;
            startedServers.add(server);
        }
        return startedServers;
    }

    void waitUntilServersAreRunning(String host, List<String> servers, boolean reconnect) throws IOException, InterruptedException, TimeoutException {
        Thread.sleep(500L);
        if (reconnect) {
            this.client.reconnect(this.timeoutInSeconds);
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.timeoutInSeconds);
        while (System.currentTimeMillis() < endTime) {
            try {
                if (this.areServersRunning(host, servers)) {
                    break;
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            Thread.sleep(200L);
        }
        boolean running = false;
        try {
            running = this.areServersRunning(host, servers);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (!running) {
            throw new TimeoutException("Waiting for host '" + host + "' / servers " + servers + " timed out");
        }
    }

    private boolean areServersRunning(String host, List<String> servers) throws IOException {
        Address hostAddress = Address.host(host);
        if (servers == null || servers.isEmpty()) {
            ModelNodeResult result = this.ops.readAttribute(Address.host(host), "host-state", new ReadAttributeOption[0]);
            result.assertDefinedValue();
            return ServerState.isRunning(result.stringValue());
        }
        for (String server : servers) {
            Address serverAddress = hostAddress.and("server", server);
            ModelNodeResult result = this.ops.readAttribute(serverAddress, "server-state", new ReadAttributeOption[0]);
            if (result.hasDefinedValue() && ServerState.isRunning(result.stringValue())) continue;
            return false;
        }
        return true;
    }
}

