/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations.admin;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;
import org.wildfly.extras.creaper.core.online.operations.admin.CommonRestartOperation;
import org.wildfly.extras.creaper.core.online.operations.admin.DomainAdministrationOperations;

public final class DomainAdministration
extends Administration {
    private final OnlineManagementClient client;
    private final Operations ops;
    private final DomainAdministrationOperations domainOps;

    public DomainAdministration(OnlineManagementClient client) {
        this(client, 60);
    }

    public DomainAdministration(OnlineManagementClient client, int timeoutInSeconds) {
        super(client);
        this.client = client;
        this.ops = new Operations(client);
        this.domainOps = new DomainAdministrationOperations(client, timeoutInSeconds);
    }

    public List<String> serverGroups() throws IOException {
        ModelNodeResult result = this.ops.readChildrenNames(Address.root(), "server-group");
        result.assertDefinedValue();
        return result.stringListValue();
    }

    public List<String> hosts() throws IOException {
        ModelNodeResult result = this.ops.readChildrenNames(Address.root(), "host");
        result.assertDefinedValue();
        return result.stringListValue();
    }

    public List<String> allRunningServers() throws IOException {
        return this.allRunningServers(this.client.options().defaultHost);
    }

    public List<String> allRunningServers(String host) throws IOException {
        return this.domainOps.allRunningServers(host);
    }

    public List<String> allServers() throws IOException {
        return this.allServers(this.client.options().defaultHost);
    }

    public List<String> allServers(String host) throws IOException {
        ModelNodeResult result = this.ops.readChildrenNames(Address.host(host), "server-config");
        result.assertDefinedValue();
        return result.stringListValue();
    }

    public boolean startServer(String server) throws IOException {
        return this.startServer(this.client.options().defaultHost, server);
    }

    public boolean startServer(String host, String server) throws IOException {
        ModelNodeResult result = this.ops.invoke("start", Address.host(host).and("server-config", server), Values.of("blocking", true));
        result.assertDefinedValue();
        return result.isSuccess();
    }

    public boolean isReloadRequired(String host) throws IOException {
        return this.domainOps.isRestartOperationRequired(host, CommonRestartOperation.RELOAD);
    }

    public void reload(String host) throws IOException, InterruptedException, TimeoutException {
        this.domainOps.performRestartOperation(host, CommonRestartOperation.RELOAD);
    }

    public boolean reloadIfRequired(String host) throws IOException, InterruptedException, TimeoutException {
        if (this.domainOps.isRestartOperationRequired(host, CommonRestartOperation.RELOAD)) {
            this.reload(host);
            return true;
        }
        return false;
    }

    public boolean isRestartRequired(String host) throws IOException {
        return this.domainOps.isRestartOperationRequired(host, CommonRestartOperation.RESTART);
    }

    public void restart(String host) throws IOException, InterruptedException, TimeoutException {
        this.domainOps.performRestartOperation(host, CommonRestartOperation.RESTART);
    }

    public boolean restartIfRequired(String host) throws IOException, InterruptedException, TimeoutException {
        if (this.domainOps.isRestartOperationRequired(host, CommonRestartOperation.RESTART)) {
            this.restart(host);
            return true;
        }
        return false;
    }

    public void restartAllServers() throws InterruptedException, IOException, TimeoutException {
        this.restartAllServers(this.client.options().defaultHost);
    }

    public void restartAllServers(String host) throws InterruptedException, TimeoutException, IOException {
        this.restartServers(host, this.allRunningServers(host));
    }

    public void restartServer(String server) throws InterruptedException, TimeoutException, IOException {
        this.restartServer(this.client.options().defaultHost, server);
    }

    public void restartServer(String host, String server) throws InterruptedException, TimeoutException, IOException {
        this.restartServers(host, Collections.singletonList(server));
    }

    void restartServers(String host, List<String> servers) throws IOException, InterruptedException, TimeoutException {
        Batch batch = new Batch();
        for (String server : servers) {
            batch.invoke("restart", Address.host(host).and("server-config", server));
        }
        boolean needsToReconnect = false;
        try {
            this.ops.batch(batch);
        }
        catch (Throwable e) {
            needsToReconnect = true;
        }
        this.domainOps.waitUntilServersAreRunning(host, servers, needsToReconnect);
    }

    public void shutdown(String host) throws IOException, InterruptedException, TimeoutException {
        this.domainOps.shutdown(host, 0);
    }

    public void shutdownAllServers() throws InterruptedException, IOException, TimeoutException {
        this.shutdownAllServers(this.client.options().defaultHost);
    }

    public void shutdownAllServers(String host) throws InterruptedException, TimeoutException, IOException {
        this.shutdownServers(host, this.allRunningServers(host));
    }

    public void shutdownServer(String server) throws InterruptedException, TimeoutException, IOException {
        this.shutdownServer(this.client.options().defaultHost, server);
    }

    public void shutdownServer(String host, String server) throws InterruptedException, TimeoutException, IOException {
        this.shutdownServers(host, Collections.singletonList(server));
    }

    void shutdownServers(String host, List<String> servers) throws IOException, InterruptedException, TimeoutException {
        Batch batch = new Batch();
        for (String server : servers) {
            batch.invoke("stop", Address.host(host).and("server-config", server));
        }
        this.ops.batch(batch);
    }

    public void shutdownGracefully(String host, int timeoutInSeconds) throws IOException, InterruptedException, TimeoutException {
        this.client.version().assertAtLeast(ServerVersion.VERSION_3_0_0, "Graceful shutdown is only supported since WildFly 9");
        this.domainOps.shutdown(host, timeoutInSeconds);
    }

    public void shutdownAllServersGracefully(int timeoutInSeconds) throws InterruptedException, IOException, TimeoutException {
        this.shutdownAllServersGracefully(this.client.options().defaultHost, timeoutInSeconds);
    }

    public void shutdownAllServersGracefully(String host, int timeoutInSeconds) throws InterruptedException, TimeoutException, IOException {
        this.shutdownServersGracefully(host, this.allRunningServers(host), timeoutInSeconds);
    }

    public void shutdownServerGracefully(String server, int timeoutInSeconds) throws InterruptedException, TimeoutException, IOException {
        this.shutdownServerGracefully(this.client.options().defaultHost, server, timeoutInSeconds);
    }

    public void shutdownServerGracefully(String host, String server, int timeoutInSeconds) throws InterruptedException, TimeoutException, IOException {
        this.shutdownServersGracefully(host, Collections.singletonList(server), timeoutInSeconds);
    }

    void shutdownServersGracefully(String host, List<String> servers, int timeoutInSeconds) throws IOException, InterruptedException, TimeoutException {
        this.client.version().assertAtLeast(ServerVersion.VERSION_3_0_0, "Graceful shutdown is only supported since WildFly 9");
        Batch batch = new Batch();
        for (String server : servers) {
            batch.invoke("stop", Address.host(host).and("server-config", server), Values.of("timeout", timeoutInSeconds));
        }
        this.ops.batch(batch);
    }

    public void waitUntilRunning(String host) throws InterruptedException, TimeoutException, IOException {
        this.domainOps.waitUntilServersAreRunning(host, null, true);
    }

    public void waitUntilServersRunning(List<String> servers) throws InterruptedException, TimeoutException, IOException {
        this.domainOps.waitUntilServersAreRunning(this.client.options().defaultHost, servers, true);
    }

    public void waitUntilServersRunning(String host, List<String> servers) throws InterruptedException, TimeoutException, IOException {
        this.domainOps.waitUntilServersAreRunning(host, servers, true);
    }

    public boolean stopServer(String server) throws IOException {
        return this.stopServer(this.client.options().defaultHost, server);
    }

    public boolean stopServer(String host, String server) throws IOException {
        ModelNodeResult result = this.ops.invoke("stop", Address.host(host).and("server-config", server), Values.of("blocking", true));
        result.assertDefinedValue();
        return result.isSuccess();
    }

    public boolean removeServer(String server) throws IOException, OperationException {
        return this.removeServer(this.client.options().defaultHost, server);
    }

    public boolean removeServer(String host, String server) throws IOException, OperationException {
        return this.ops.removeIfExists(Address.host(host).and("server-config", server));
    }
}

