/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations.admin;

import java.io.IOException;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.RestartOperation;

enum CommonRestartOperation implements RestartOperation
{
    RELOAD{

        @Override
        public boolean isRequired(ModelNodeResult serverStateResult, boolean isManagedServerInDomain) {
            if (isManagedServerInDomain && "restart-required".equals(serverStateResult.stringValue())) {
                return true;
            }
            return "reload-required".equals(serverStateResult.stringValue());
        }

        @Override
        public ModelNodeResult perform(Operations ops, Address address) throws IOException {
            return ops.invoke("reload", address);
        }
    }
    ,
    RESTART{

        @Override
        public boolean isRequired(ModelNodeResult serverStateResult, boolean isManagedServerInDomain) {
            serverStateResult.assertDefinedValue();
            return "restart-required".equals(serverStateResult.stringValue());
        }

        @Override
        public ModelNodeResult perform(Operations ops, Address address) throws IOException {
            return ops.invoke("shutdown", address, Values.of("restart", true));
        }
    };


    abstract boolean isRequired(ModelNodeResult var1, boolean var2);
}

