/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations.admin;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.admin.AdministrationOperations;
import org.wildfly.extras.creaper.core.online.operations.admin.DomainAdministrationOperations;
import org.wildfly.extras.creaper.core.online.operations.admin.StandaloneAdministrationOperations;

public class Administration {
    static final int DEFAULT_TIMEOUT = 60;
    private final OnlineManagementClient client;
    private final AdministrationOperations ops;

    public Administration(OnlineManagementClient client) {
        this(client, 60);
    }

    public Administration(OnlineManagementClient client, int timeoutInSeconds) {
        this.client = client;
        this.ops = client.options().isDomain ? new DomainAdministrationOperations(client, timeoutInSeconds) : new StandaloneAdministrationOperations(client, timeoutInSeconds);
    }

    public final boolean isReloadRequired() {
        try {
            return this.ops.isReloadRequired();
        }
        catch (IOException e) {
            throw Administration.sneakyThrow(e);
        }
    }

    public final void reload() throws IOException, InterruptedException, TimeoutException {
        this.ops.reload();
    }

    public final boolean reloadIfRequired() throws IOException, InterruptedException, TimeoutException {
        return this.ops.reloadIfRequired();
    }

    public final boolean isRestartRequired() {
        try {
            return this.ops.isRestartRequired();
        }
        catch (IOException e) {
            throw Administration.sneakyThrow(e);
        }
    }

    public final void restart() throws IOException, InterruptedException, TimeoutException {
        this.ops.restart();
    }

    public final boolean restartIfRequired() throws IOException, InterruptedException, TimeoutException {
        return this.ops.restartIfRequired();
    }

    public final void shutdown() throws IOException {
        this.ops.shutdown(0);
    }

    public final void shutdownGracefully(int timeoutInSeconds) throws IOException {
        this.client.version().assertAtLeast(ServerVersion.VERSION_3_0_0, "Graceful shutdown is only supported since WildFly 9");
        this.ops.shutdown(timeoutInSeconds);
    }

    public final void waitUntilRunning() {
        try {
            this.ops.waitUntilRunning();
        }
        catch (InterruptedException e) {
            throw Administration.sneakyThrow(e);
        }
        catch (IOException e) {
            throw Administration.sneakyThrow(e);
        }
        catch (TimeoutException e) {
            throw Administration.sneakyThrow(e);
        }
    }

    private static RuntimeException sneakyThrow(Throwable t) {
        Administration.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }
}

