/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public final class Values {
    private static final Values EMPTY = new Values();
    private final List<Property> namedValues;

    public static Values empty() {
        return EMPTY;
    }

    public static Values of(String name, boolean value) {
        return EMPTY.and(name, value);
    }

    public static Values of(String name, int value) {
        return EMPTY.and(name, value);
    }

    public static Values of(String name, long value) {
        return EMPTY.and(name, value);
    }

    public static Values of(String name, double value) {
        return EMPTY.and(name, value);
    }

    public static Values of(String name, String value) {
        return EMPTY.and(name, value);
    }

    public static Values of(String name, ModelNode value) {
        return EMPTY.and(name, value);
    }

    public static Values ofList(String name, boolean ... value) {
        return EMPTY.andList(name, value);
    }

    public static Values ofList(String name, int ... value) {
        return EMPTY.andList(name, value);
    }

    public static Values ofList(String name, long ... value) {
        return EMPTY.andList(name, value);
    }

    public static Values ofList(String name, double ... value) {
        return EMPTY.andList(name, value);
    }

    public static Values ofList(String name, String ... value) {
        return EMPTY.andList(name, value);
    }

    public static Values ofList(String name, ModelNode ... value) {
        return EMPTY.andList(name, value);
    }

    public static Values ofObject(String name, Values object) {
        return EMPTY.andObject(name, object);
    }

    public static Values fromMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Property> properties = new ArrayList<Property>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.add(new Property(entry.getKey(), new ModelNode(entry.getValue())));
        }
        return new Values(properties);
    }

    private Values() {
        this.namedValues = Collections.emptyList();
    }

    private Values(List<Property> namedValues) {
        this.namedValues = Collections.unmodifiableList(namedValues);
    }

    public Values and(String name, boolean value) {
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, new ModelNode(value)));
        return new Values(newList);
    }

    public Values and(String name, int value) {
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, new ModelNode(value)));
        return new Values(newList);
    }

    public Values and(String name, long value) {
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, new ModelNode(value)));
        return new Values(newList);
    }

    public Values and(String name, double value) {
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, new ModelNode(value)));
        return new Values(newList);
    }

    public Values and(String name, String value) {
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, new ModelNode(value)));
        return new Values(newList);
    }

    public Values and(String name, ModelNode value) {
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, value));
        return new Values(newList);
    }

    public Values andOptional(String name, Boolean value) {
        if (value == null) {
            return this;
        }
        return this.and(name, value);
    }

    public Values andOptional(String name, Integer value) {
        if (value == null) {
            return this;
        }
        return this.and(name, value);
    }

    public Values andOptional(String name, Long value) {
        if (value == null) {
            return this;
        }
        return this.and(name, value);
    }

    public Values andOptional(String name, Double value) {
        if (value == null) {
            return this;
        }
        return this.and(name, value);
    }

    public Values andOptional(String name, String value) {
        if (value == null) {
            return this;
        }
        return this.and(name, value);
    }

    public Values andOptional(String name, ModelNode value) {
        if (value == null) {
            return this;
        }
        return this.and(name, value);
    }

    public Values andList(String name, boolean ... value) {
        ModelNode listValue = new ModelNode().setEmptyList();
        for (boolean singleValue : value) {
            listValue.add(singleValue);
        }
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, listValue));
        return new Values(newList);
    }

    public Values andList(String name, int ... value) {
        ModelNode listValue = new ModelNode().setEmptyList();
        for (int singleValue : value) {
            listValue.add(singleValue);
        }
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, listValue));
        return new Values(newList);
    }

    public Values andList(String name, long ... value) {
        ModelNode listValue = new ModelNode().setEmptyList();
        for (long singleValue : value) {
            listValue.add(singleValue);
        }
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, listValue));
        return new Values(newList);
    }

    public Values andList(String name, double ... value) {
        ModelNode listValue = new ModelNode().setEmptyList();
        for (double singleValue : value) {
            listValue.add(singleValue);
        }
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, listValue));
        return new Values(newList);
    }

    public Values andList(String name, String ... value) {
        ModelNode listValue = new ModelNode().setEmptyList();
        for (String singleValue : value) {
            listValue.add(singleValue);
        }
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, listValue));
        return new Values(newList);
    }

    public Values andList(String name, ModelNode ... value) {
        ModelNode listValue = new ModelNode().setEmptyList();
        for (ModelNode singleValue : value) {
            listValue.add(singleValue);
        }
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, listValue));
        return new Values(newList);
    }

    public <T> Values andList(Class<T> clazz, String name, List<T> value) {
        if (clazz == Boolean.class) {
            return this.andList(name, Booleans.toArray(value));
        }
        if (clazz == Integer.class) {
            return this.andList(name, Ints.toArray(value));
        }
        if (clazz == Long.class) {
            return this.andList(name, Longs.toArray(value));
        }
        if (clazz == Double.class) {
            return this.andList(name, Doubles.toArray(value));
        }
        if (clazz == String.class) {
            return this.andList(name, value.toArray(new String[value.size()]));
        }
        if (clazz == ModelNode.class) {
            return this.andList(name, value.toArray(new ModelNode[value.size()]));
        }
        throw new IllegalArgumentException("Only List<Boolean>, List<Integer>, List<Long>, List<Double>, List<String> and List<ModelNode> are supported");
    }

    public <T> Values andListOptional(Class<T> clazz, String name, List<T> value) {
        if (value == null) {
            return this;
        }
        return this.andList(clazz, name, value);
    }

    public Values andObject(String name, Values value) {
        ModelNode objectValue = new ModelNode().setEmptyObject();
        for (Property property : value.namedValues) {
            objectValue.get(property.getName()).set(property.getValue());
        }
        ArrayList<Property> newList = new ArrayList<Property>(this.namedValues);
        newList.add(new Property(name, objectValue));
        return new Values(newList);
    }

    public Values andObjectOptional(String name, Values value) {
        if (value == null) {
            return this;
        }
        return this.andObject(name, value);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("(");
        boolean first = true;
        for (Property namedValue : this.namedValues) {
            if (!first) {
                result.append(", ");
            }
            result.append(namedValue.getName()).append("=").append(namedValue.getValue().asString());
            first = false;
        }
        result.append(")");
        return result.toString();
    }

    void addToModelNode(ModelNode modelNode) {
        for (Property namedValue : this.namedValues) {
            modelNode.get(namedValue.getName()).set(namedValue.getValue());
        }
    }

    int size() {
        return this.namedValues.size();
    }
}

