/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations;

import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOptionInternal;
import org.wildfly.extras.creaper.core.online.operations.ReadResourceOption;
import org.wildfly.extras.creaper.core.online.operations.ReadResourceOptionInternal;
import org.wildfly.extras.creaper.core.online.operations.SharedCommonOperations;
import org.wildfly.extras.creaper.core.online.operations.Values;

final class OperationsModelNodeBuilder
implements SharedCommonOperations<ModelNode> {
    private final Values headers;

    OperationsModelNodeBuilder() {
        this(null);
    }

    private OperationsModelNodeBuilder(Values headers) {
        this.headers = headers;
    }

    OperationsModelNodeBuilder withHeaders(Values headers) {
        if (this.headers != null) {
            throw new IllegalStateException("Headers were already set to " + this.headers + ", can't set headers again: " + headers);
        }
        return new OperationsModelNodeBuilder(headers);
    }

    private ModelNode newOp() {
        ModelNode op = new ModelNode();
        if (this.headers != null) {
            this.headers.addToModelNode(op.get("operation-headers"));
        }
        return op;
    }

    @Override
    public ModelNode whoami() {
        ModelNode op = this.newOp();
        op.get("operation").set("whoami");
        op.get("address").setEmptyList();
        return op;
    }

    @Override
    public ModelNode readAttribute(Address address, String attributeName, ReadAttributeOption ... options) {
        ModelNode op = this.newOp();
        op.get("operation").set("read-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set(attributeName);
        for (ReadAttributeOption option : options) {
            if (!(option instanceof ReadAttributeOptionInternal)) continue;
            ((ReadAttributeOptionInternal)option).modifyReadAttributeOperation(op);
        }
        return op;
    }

    @Override
    public ModelNode writeAttribute(Address address, String attributeName, boolean attributeValue) {
        return this.writeAttribute(address, attributeName, new ModelNode(attributeValue));
    }

    @Override
    public ModelNode writeAttribute(Address address, String attributeName, int attributeValue) {
        return this.writeAttribute(address, attributeName, new ModelNode(attributeValue));
    }

    @Override
    public ModelNode writeAttribute(Address address, String attributeName, long attributeValue) {
        return this.writeAttribute(address, attributeName, new ModelNode(attributeValue));
    }

    @Override
    public ModelNode writeAttribute(Address address, String attributeName, String attributeValue) {
        return this.writeAttribute(address, attributeName, new ModelNode(attributeValue));
    }

    @Override
    public ModelNode writeAttribute(Address address, String attributeName, ModelNode attributeValue) {
        ModelNode op = this.newOp();
        op.get("operation").set("write-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set(attributeName);
        op.get("value").set(attributeValue);
        return op;
    }

    @Override
    public ModelNode writeListAttribute(Address address, String attributeName, boolean ... attributeValue) {
        ModelNode listAttributeValue = new ModelNode().setEmptyList();
        for (boolean singleValue : attributeValue) {
            listAttributeValue.add(singleValue);
        }
        return this.writeAttribute(address, attributeName, listAttributeValue);
    }

    @Override
    public ModelNode writeListAttribute(Address address, String attributeName, int ... attributeValue) {
        ModelNode listAttributeValue = new ModelNode().setEmptyList();
        for (int singleValue : attributeValue) {
            listAttributeValue.add(singleValue);
        }
        return this.writeAttribute(address, attributeName, listAttributeValue);
    }

    @Override
    public ModelNode writeListAttribute(Address address, String attributeName, long ... attributeValue) {
        ModelNode listAttributeValue = new ModelNode().setEmptyList();
        for (long singleValue : attributeValue) {
            listAttributeValue.add(singleValue);
        }
        return this.writeAttribute(address, attributeName, listAttributeValue);
    }

    @Override
    public ModelNode writeListAttribute(Address address, String attributeName, String ... attributeValue) {
        ModelNode listAttributeValue = new ModelNode().setEmptyList();
        for (String singleValue : attributeValue) {
            listAttributeValue.add(singleValue);
        }
        return this.writeAttribute(address, attributeName, listAttributeValue);
    }

    @Override
    public ModelNode writeListAttribute(Address address, String attributeName, ModelNode ... attributeValue) {
        ModelNode listAttributeValue = new ModelNode().setEmptyList();
        for (ModelNode singleValue : attributeValue) {
            listAttributeValue.add(singleValue);
        }
        return this.writeAttribute(address, attributeName, listAttributeValue);
    }

    @Override
    public ModelNode undefineAttribute(Address address, String attributeName) {
        ModelNode op = this.newOp();
        op.get("operation").set("undefine-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set(attributeName);
        return op;
    }

    @Override
    public ModelNode readResource(Address address, ReadResourceOption ... options) {
        ModelNode op = this.newOp();
        op.get("operation").set("read-resource");
        op.get("address").set(address.toModelNode());
        for (ReadResourceOption option : options) {
            if (!(option instanceof ReadResourceOptionInternal)) continue;
            ((ReadResourceOptionInternal)option).modifyReadResourceOperation(op);
        }
        return op;
    }

    @Override
    public ModelNode readChildrenNames(Address address, String childType) {
        ModelNode op = this.newOp();
        op.get("operation").set("read-children-names");
        op.get("address").set(address.toModelNode());
        op.get("child-type").set(childType);
        return op;
    }

    @Override
    public ModelNode add(Address address) {
        return this.add(address, Values.empty());
    }

    @Override
    public ModelNode add(Address address, Values parameters) {
        ModelNode op = this.newOp();
        op.get("operation").set("add");
        op.get("address").set(address.toModelNode());
        parameters.addToModelNode(op);
        return op;
    }

    @Override
    public ModelNode remove(Address address) {
        ModelNode op = this.newOp();
        op.get("operation").set("remove");
        op.get("address").set(address.toModelNode());
        return op;
    }

    @Override
    public ModelNode invoke(String operationName, Address address) {
        return this.invoke(operationName, address, Values.empty());
    }

    @Override
    public ModelNode invoke(String operationName, Address address, Values parameters) {
        ModelNode op = this.newOp();
        op.get("operation").set(operationName);
        op.get("address").set(address.toModelNode());
        parameters.addToModelNode(op);
        return op;
    }
}

