/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations;

import java.io.IOException;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extras.creaper.core.online.Constants;
import org.wildfly.extras.creaper.core.online.FailuresAllowedBlock;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.OperationsModelNodeBuilder;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.ReadResourceOption;
import org.wildfly.extras.creaper.core.online.operations.SharedCommonOperations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class Operations
implements SharedCommonOperations<ModelNodeResult> {
    private final OnlineManagementClient client;
    private final OperationsModelNodeBuilder builder;

    public Operations(OnlineManagementClient client) {
        this(client, new OperationsModelNodeBuilder());
    }

    private Operations(OnlineManagementClient client, OperationsModelNodeBuilder builder) {
        this.client = client;
        this.builder = builder;
    }

    public Operations headers(Values headers) {
        return new Operations(this.client, this.builder.withHeaders(headers));
    }

    @Override
    public ModelNodeResult whoami() throws IOException {
        return this.client.execute(this.builder.whoami());
    }

    @Override
    public ModelNodeResult readAttribute(Address address, String attributeName, ReadAttributeOption ... options) throws IOException {
        return this.client.execute(this.builder.readAttribute(address, attributeName, options));
    }

    @Override
    public ModelNodeResult writeAttribute(Address address, String attributeName, boolean attributeValue) throws IOException {
        return this.client.execute(this.builder.writeAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeAttribute(Address address, String attributeName, int attributeValue) throws IOException {
        return this.client.execute(this.builder.writeAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeAttribute(Address address, String attributeName, long attributeValue) throws IOException {
        return this.client.execute(this.builder.writeAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeAttribute(Address address, String attributeName, String attributeValue) throws IOException {
        return this.client.execute(this.builder.writeAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeAttribute(Address address, String attributeName, ModelNode attributeValue) throws IOException {
        return this.client.execute(this.builder.writeAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeListAttribute(Address address, String attributeName, boolean ... attributeValue) throws IOException {
        return this.client.execute(this.builder.writeListAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeListAttribute(Address address, String attributeName, int ... attributeValue) throws IOException {
        return this.client.execute(this.builder.writeListAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeListAttribute(Address address, String attributeName, long ... attributeValue) throws IOException {
        return this.client.execute(this.builder.writeListAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeListAttribute(Address address, String attributeName, String ... attributeValue) throws IOException {
        return this.client.execute(this.builder.writeListAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult writeListAttribute(Address address, String attributeName, ModelNode ... attributeValue) throws IOException {
        return this.client.execute(this.builder.writeListAttribute(address, attributeName, attributeValue));
    }

    @Override
    public ModelNodeResult undefineAttribute(Address address, String attributeName) throws IOException {
        return this.client.execute(this.builder.undefineAttribute(address, attributeName));
    }

    @Override
    public ModelNodeResult readResource(Address address, ReadResourceOption ... options) throws IOException {
        return this.client.execute(this.builder.readResource(address, options));
    }

    @Override
    public ModelNodeResult readChildrenNames(Address address, String childType) throws IOException {
        return this.client.execute(this.builder.readChildrenNames(address, childType));
    }

    @Override
    public ModelNodeResult add(Address address) throws IOException {
        return this.client.execute(this.builder.add(address));
    }

    @Override
    public ModelNodeResult add(Address address, Values parameters) throws IOException {
        return this.client.execute(this.builder.add(address, parameters));
    }

    @Override
    public ModelNodeResult remove(Address address) throws IOException {
        return this.client.execute(this.builder.remove(address));
    }

    @Override
    public ModelNodeResult invoke(String operationName, Address address) throws IOException {
        return this.client.execute(this.builder.invoke(operationName, address));
    }

    @Override
    public ModelNodeResult invoke(String operationName, Address address, Values parameters) throws IOException {
        return this.client.execute(this.builder.invoke(operationName, address, parameters));
    }

    public ModelNodeResult batch(Batch batch) throws IOException {
        return this.client.execute(batch.toModelNode());
    }

    public boolean exists(Address address) throws IOException, OperationException {
        FailuresAllowedBlock expectedFailures = this.client.allowFailures();
        try {
            ModelNodeResult result = this.readResource(address, new ReadResourceOption[0]);
            if (result.isSuccess()) {
                boolean bl = result.hasDefinedValue();
                return bl;
            }
            if (Operations.isResultUnknownOrNotFound(result)) {
                boolean bl = false;
                return bl;
            }
            throw new OperationException("exists failed: " + result.asString());
        }
        finally {
            expectedFailures.close();
        }
    }

    public boolean removeIfExists(Address address) throws IOException, OperationException {
        FailuresAllowedBlock expectedFailures = this.client.allowFailures();
        try {
            ModelNodeResult result = this.remove(address);
            if (result.isSuccess()) {
                boolean bl = true;
                return bl;
            }
            if (Operations.isResultUnknownOrNotFound(result)) {
                boolean bl = false;
                return bl;
            }
            throw new OperationException("removeIfExists failed: " + result.asString());
        }
        finally {
            expectedFailures.close();
        }
    }

    static boolean isResultUnknownOrNotFound(ModelNodeResult result) {
        result.assertFailed();
        ModelNode failureDescription = result.get("failure-description");
        if (failureDescription.hasDefined("host-failure-descriptions")) {
            List hostFailures = failureDescription.get("host-failure-descriptions").asPropertyList();
            for (Property hostFailure : hostFailures) {
                if (!Operations.isFailureDesriptionUnknownOrNotFound(hostFailure.getValue().asString())) continue;
                return true;
            }
            return false;
        }
        if (failureDescription.hasDefined("domain-failure-description")) {
            failureDescription = failureDescription.get("domain-failure-description");
        }
        return Operations.isFailureDesriptionUnknownOrNotFound(failureDescription.asString());
    }

    private static boolean isFailureDesriptionUnknownOrNotFound(String failureDescription) {
        for (String code : Constants.RESULT_CODES_FOR_UNKNOWN_OR_NOT_FOUND) {
            if (!failureDescription.startsWith(code)) continue;
            return true;
        }
        return false;
    }
}

