/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;

public final class Address {
    private final List<StringPair> address;

    public static Address root() {
        return new Address(Collections.<StringPair>emptyList());
    }

    public static Address extension(String extension) {
        return Address.of("extension", extension);
    }

    public static Address host(String host) {
        return Address.of("host", host);
    }

    public static Address subsystem(String subsystemName) {
        return Address.of("subsystem", subsystemName);
    }

    public static Address coreService(String coreServiceName) {
        return Address.of("core-service", coreServiceName);
    }

    public static Address deployment(String deploymentName) {
        return Address.of("deployment", deploymentName);
    }

    public static Address of(String key, String value) {
        return new Address(Collections.singletonList(new StringPair(key, value)));
    }

    private Address(List<StringPair> address) {
        this.address = Collections.unmodifiableList(address);
    }

    public Address and(String key, String value) {
        ArrayList<StringPair> newAddress = new ArrayList<StringPair>(this.address);
        newAddress.add(new StringPair(key, value));
        return new Address(newAddress);
    }

    ModelNode toModelNode() {
        ModelNode result = new ModelNode();
        result.setEmptyList();
        for (StringPair pair : this.address) {
            result.add(pair.key, pair.value);
        }
        return result;
    }

    public String getLastPairValue() {
        if (this.address.isEmpty()) {
            return null;
        }
        StringPair last = this.address.get(this.address.size() - 1);
        return last.value;
    }

    public String toString() {
        if (this.address.isEmpty()) {
            return "/";
        }
        StringBuilder result = new StringBuilder();
        for (StringPair addressElement : this.address) {
            result.append("/").append(addressElement.key).append("=").append(addressElement.value);
        }
        return result.toString();
    }

    private static final class StringPair {
        private final String key;
        private final String value;

        private StringPair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

