/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import com.google.common.io.ByteSource;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.wildfly.extras.creaper.core.online.KeyStoreType;
import org.wildfly.extras.creaper.core.online.SslProtocol;

public final class SslOptions {
    private static final SslProtocol DEFAULT_PROTOCOL = SslProtocol.TLS;
    final SslProtocol protocol;
    final ByteSource keyStoreSource;
    final String keyStorePassword;
    final KeyStoreType keyStoreType;
    final String keyAlias;
    final String keyPassword;
    final ByteSource trustStoreSource;
    final String trustStorePassword;
    final KeyStoreType trustStoreType;
    final boolean hostnameVerification;

    private SslOptions(Builder builder) {
        this.protocol = builder.protocol != null ? builder.protocol : DEFAULT_PROTOCOL;
        this.keyStoreSource = builder.keyStoreSource;
        this.keyStorePassword = builder.keyStorePassword;
        this.keyStoreType = builder.keyStoreType != null ? builder.keyStoreType : KeyStoreType.DEFAULT_TYPE;
        this.keyAlias = builder.keyAlias;
        this.keyPassword = builder.keyPassword;
        this.trustStoreSource = builder.trustStoreSource;
        this.trustStorePassword = builder.trustStorePassword;
        this.trustStoreType = builder.trustStoreType != null ? builder.trustStoreType : KeyStoreType.DEFAULT_TYPE;
        this.hostnameVerification = builder.hostnameVerification;
    }

    SSLContext createSslContext() {
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        try {
            SSLContext sslContext = SSLContext.getInstance(this.protocol.protocolName());
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Failed to create SSLContext.", ex);
        }
    }

    private KeyManager[] getKeyManagers() {
        if (this.keyStoreSource == null && this.keyStoreType != KeyStoreType.PKCS11) {
            return null;
        }
        if (this.keyStoreSource != null && this.keyStoreType == KeyStoreType.PKCS11) {
            throw new IllegalArgumentException("The keystore type is PKCS#11, the keystore should not be set.");
        }
        KeyManagerFactory keyManagerFactory = SslOptions.createKeyManagerFactory();
        KeyStore keyStore = this.createKeyStore();
        char[] password = SslOptions.toCharArray(this.keyPassword != null ? this.keyPassword : this.keyStorePassword);
        if (this.keyAlias != null) {
            keyStore = this.createRepacementKeyStore(keyStore, password);
        }
        try {
            keyManagerFactory.init(keyStore, password);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Failed to init KeyManagerFactory for " + this.keyStoreSource, ex);
        }
        return keyManagerFactory.getKeyManagers();
    }

    private TrustManager[] getTrustManagers() {
        if (this.trustStoreSource == null && this.trustStoreType != KeyStoreType.PKCS11) {
            return null;
        }
        if (this.trustStoreSource != null && this.trustStoreType == KeyStoreType.PKCS11) {
            throw new IllegalArgumentException("The truststore type is PKCS#11, the truststore should not be set.");
        }
        TrustManagerFactory trustManagerFactory = SslOptions.createTrustManagerFactory();
        KeyStore trustStore = this.createTrustStore();
        try {
            trustManagerFactory.init(trustStore);
        }
        catch (KeyStoreException ex) {
            throw new IllegalArgumentException("Failed to init TrustManagerFactory for " + this.trustStoreSource, ex);
        }
        return trustManagerFactory.getTrustManagers();
    }

    private KeyStore createKeyStore() {
        KeyStore keyStore = SslOptions.createStore(this.keyStoreType);
        InputStream keyStoreStream = null;
        if (this.keyStoreSource != null) {
            keyStoreStream = SslOptions.createStoreStream(this.keyStoreSource);
        }
        try {
            keyStore.load(keyStoreStream, SslOptions.toCharArray(this.keyStorePassword));
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof UnrecoverableKeyException) {
                throw new IllegalArgumentException("Failed to load keystore. Maybe the password is not correct.", ex);
            }
            throw new IllegalStateException("Failed to load keystore. Maybe the keystore type is not correct.", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Failed to load keystore.", ex);
        }
        catch (CertificateException ex) {
            throw new IllegalStateException("Failed to load keystore.", ex);
        }
        finally {
            Closeables.closeQuietly((InputStream)keyStoreStream);
        }
        return keyStore;
    }

    private KeyStore createRepacementKeyStore(KeyStore keyStore, char[] password) {
        KeyStore.Entry keyEntry;
        KeyStore replacementKeyStore = SslOptions.createEmptyStore(KeyStoreType.DEFAULT_TYPE);
        KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(password);
        try {
            keyEntry = keyStore.getEntry(this.keyAlias, protection);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Failed to read certificate for alias " + this.keyAlias, ex);
        }
        catch (UnrecoverableEntryException ex) {
            throw new IllegalStateException("Failed to read certificate for alias '" + this.keyAlias + "'. Maybe the password is not correct.", ex);
        }
        catch (KeyStoreException ex) {
            throw new IllegalStateException("Failed to read certificate for alias " + this.keyAlias, ex);
        }
        if (keyEntry == null) {
            throw new IllegalStateException("Failed to read certificate for alias '" + this.keyAlias + "'. Maybe wrong alias was provided.");
        }
        try {
            replacementKeyStore.setEntry(this.keyAlias, keyEntry, protection);
        }
        catch (KeyStoreException ex) {
            throw new IllegalStateException("Failed to write certificate for alias " + this.keyAlias, ex);
        }
        return replacementKeyStore;
    }

    private KeyStore createTrustStore() {
        KeyStore trustStore = SslOptions.createStore(this.trustStoreType);
        InputStream trustStoreStream = null;
        if (this.trustStoreSource != null) {
            trustStoreStream = SslOptions.createStoreStream(this.trustStoreSource);
        }
        try {
            trustStore.load(trustStoreStream, SslOptions.toCharArray(this.trustStorePassword));
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof UnrecoverableKeyException) {
                throw new IllegalArgumentException("Failed to load truststore. Maybe the password is not correct.", ex);
            }
            throw new IllegalStateException("Failed to load truststore. Maybe the truststore type is not correct.", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Failed to load truststore.", ex);
        }
        catch (CertificateException ex) {
            throw new IllegalStateException("Failed to load truststore.", ex);
        }
        finally {
            Closeables.closeQuietly((InputStream)trustStoreStream);
        }
        return trustStore;
    }

    private static KeyManagerFactory createKeyManagerFactory() {
        try {
            return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("KeyManagerFactory cannot be instantiated with default algorithm.", ex);
        }
    }

    private static TrustManagerFactory createTrustManagerFactory() {
        try {
            return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("TrustManagerFactory cannot be instantiated with default algorithm.", ex);
        }
    }

    private static KeyStore createStore(KeyStoreType storeType) {
        try {
            return KeyStore.getInstance(storeType.typeName());
        }
        catch (KeyStoreException ex) {
            throw new IllegalArgumentException("KeyStore of type '" + (Object)((Object)storeType) + "' cannot be instantiated.", ex);
        }
    }

    private static KeyStore createEmptyStore(KeyStoreType storeType) {
        KeyStore keyStore = SslOptions.createStore(storeType);
        try {
            keyStore.load(null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to load empty keystore.", ex);
        }
        return keyStore;
    }

    private static InputStream createStoreStream(ByteSource store) {
        try {
            return store.openStream();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to open store file " + store, ex);
        }
    }

    private static char[] toCharArray(String password) {
        if (password != null && !password.isEmpty()) {
            return password.toCharArray();
        }
        return null;
    }

    public static final class Builder {
        private SslProtocol protocol;
        private ByteSource keyStoreSource;
        private String keyStorePassword;
        private KeyStoreType keyStoreType;
        private String keyAlias;
        private String keyPassword;
        private ByteSource trustStoreSource;
        private String trustStorePassword;
        private KeyStoreType trustStoreType;
        private boolean hostnameVerification = true;

        public Builder protocol(SslProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder keyStore(File file) {
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("A file with the keystore must be provided.");
            }
            this.keyStoreSource = Files.asByteSource((File)file);
            return this;
        }

        public Builder keyStore(Class resourceLoader, String path) {
            if (resourceLoader == null) {
                throw new IllegalArgumentException("A class for loading the keystore must be provided.");
            }
            if (path == null) {
                throw new IllegalArgumentException("A path to the keystore must be provided.");
            }
            URL url = Resources.getResource((Class)resourceLoader, (String)path);
            this.keyStoreSource = Resources.asByteSource((URL)url);
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder key(String keyAlias, String keyPassword) {
            this.keyAlias = keyAlias;
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder keyStoreType(KeyStoreType keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder trustStore(File file) {
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("A file with the truststore must be provided.");
            }
            this.trustStoreSource = Files.asByteSource((File)file);
            return this;
        }

        public Builder trustStore(Class resourceLoader, String path) {
            if (resourceLoader == null) {
                throw new IllegalArgumentException("A class for loading the truststore must be provided.");
            }
            if (path == null) {
                throw new IllegalArgumentException("A path to the truststore must be provided.");
            }
            URL url = Resources.getResource((Class)resourceLoader, (String)path);
            this.trustStoreSource = Resources.asByteSource((URL)url);
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder trustStoreType(KeyStoreType trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder turnOffHostnameVerification() {
            this.hostnameVerification = false;
            return this;
        }

        public SslOptions build() {
            return new SslOptions(this);
        }
    }
}

