/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.io.IOException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.ManagementVersionPart;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;

final class OnlineServerVersion {
    private OnlineServerVersion() {
    }

    static ServerVersion discover(ModelControllerClient client) throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("address").setEmptyList();
        ModelNodeResult result = new ModelNodeResult(client.execute(op));
        result.assertSuccess();
        ModelNode resultValue = result.get("result");
        return ServerVersion.from(OnlineServerVersion.readPart(resultValue, ManagementVersionPart.MAJOR), OnlineServerVersion.readPart(resultValue, ManagementVersionPart.MINOR), OnlineServerVersion.readPart(resultValue, ManagementVersionPart.MICRO));
    }

    private static int readPart(ModelNode result, ManagementVersionPart part) throws IOException {
        if (result.hasDefined(part.attributeName())) {
            return result.get(part.attributeName()).asInt();
        }
        return 0;
    }
}

