/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.online.Constants;
import org.wildfly.extras.creaper.core.online.HttpModelControllerClient;
import org.wildfly.extras.creaper.core.online.LazyOnlineManagementClient;
import org.wildfly.extras.creaper.core.online.ManagementProtocol;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineManagementClientImpl;
import org.wildfly.extras.creaper.core.online.SslOptions;

public final class OnlineOptions {
    private static final String CREAPER_WILDFLY = "creaper.wildfly";
    public final boolean isStandalone;
    public final boolean isDomain;
    public String defaultProfile;
    public String defaultHost;
    final String host;
    final int port;
    private final ManagementProtocol protocol;
    private final int connectionTimeout;
    private final int bootTimeout;
    private final String username;
    private final String password;
    private final boolean localAuthDisabled;
    private final SslOptions sslOptions;
    private final ModelControllerClient wrappedModelControllerClient;
    final boolean isWrappedClient;

    private OnlineOptions(Data data) {
        if (data.protocol == null && System.getProperty(CREAPER_WILDFLY) != null) {
            if (data.sslOptions == null) {
                data.protocol = ManagementProtocol.HTTP_REMOTING;
            } else {
                data.protocol = ManagementProtocol.HTTPS_REMOTING;
            }
        }
        if (data.localDefault) {
            data.host = "localhost";
            if (data.protocol == ManagementProtocol.HTTP_REMOTING || data.protocol == ManagementProtocol.HTTP) {
                data.port = 9990;
            } else if (data.protocol == ManagementProtocol.HTTPS_REMOTING) {
                data.port = 9993;
            } else if (data.protocol == ManagementProtocol.HTTPS) {
                data.port = System.getProperty(CREAPER_WILDFLY) != null ? 9993 : 9443;
            } else {
                data.port = 9999;
            }
        }
        this.isStandalone = data.isStandalone;
        this.isDomain = data.isDomain;
        this.defaultProfile = data.defaultProfile;
        this.defaultHost = data.defaultHost;
        this.host = data.host;
        this.port = data.port;
        this.protocol = data.protocol;
        this.connectionTimeout = data.connectionTimeout;
        this.bootTimeout = data.bootTimeout;
        this.username = data.username;
        this.password = data.password;
        this.localAuthDisabled = data.localAuthDisabled;
        this.sslOptions = data.sslOptions;
        this.wrappedModelControllerClient = data.wrappedModelControllerClient;
        boolean bl = this.isWrappedClient = data.wrappedModelControllerClient != null;
        if ((this.protocol == ManagementProtocol.HTTPS || this.protocol == ManagementProtocol.HTTPS_REMOTING) && this.sslOptions == null) {
            throw new IllegalArgumentException("SSL must be configured when HTTPS or HTTPS_REMOTING protocol is used!");
        }
    }

    public static ConnectionOnlineOptions standalone() {
        Data data = new Data();
        data.isStandalone = true;
        data.bootTimeout = 20000;
        return new ConnectionOnlineOptions(data);
    }

    public static DomainOnlineOptions domain() {
        Data data = new Data();
        data.isDomain = true;
        data.bootTimeout = 120000;
        return new DomainOnlineOptions(data);
    }

    ModelControllerClient createModelControllerClient() throws IOException {
        ModelControllerClient modelControllerClient;
        if (this.wrappedModelControllerClient != null) {
            return this.wrappedModelControllerClient;
        }
        CallbackHandler callbackHandler = null;
        Map<String, String> saslOptions = null;
        SSLContext sslContext = null;
        if (this.username != null) {
            callbackHandler = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)callback;
                            ncb.setName(OnlineOptions.this.username);
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)callback;
                            pcb.setPassword(OnlineOptions.this.password.toCharArray());
                            continue;
                        }
                        if (callback instanceof RealmCallback) {
                            RealmCallback rcb = (RealmCallback)callback;
                            rcb.setText(rcb.getDefaultText());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            };
        }
        if (this.localAuthDisabled) {
            saslOptions = Collections.singletonMap("SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
        }
        if (this.sslOptions != null) {
            sslContext = this.sslOptions.createSslContext();
        }
        if (this.protocol == ManagementProtocol.HTTP || this.protocol == ManagementProtocol.HTTPS) {
            HttpModelControllerClient modelControllerClient2 = new HttpModelControllerClient(this.host, this.port, this.username, this.password, this.connectionTimeout, this.sslOptions);
            try {
                OnlineOptions.connectAndWaitUntilServerBoots(modelControllerClient2, this.connectionTimeout, this.bootTimeout);
            }
            catch (Exception e) {
                modelControllerClient2.close();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
            return modelControllerClient2;
        }
        try {
            Method createMethod = ModelControllerClient.Factory.class.getMethod("create", String.class, String.class, Integer.TYPE, CallbackHandler.class, SSLContext.class, Integer.TYPE, Map.class);
            String protocolName = null;
            if (this.protocol != null) {
                protocolName = this.protocol.protocolName();
            }
            modelControllerClient = (ModelControllerClient)createMethod.invoke(null, protocolName, this.host, this.port, callbackHandler, sslContext, this.connectionTimeout, saslOptions);
        }
        catch (NoSuchMethodException e) {
            if (this.protocol == ManagementProtocol.HTTP_REMOTING || this.protocol == ManagementProtocol.HTTPS_REMOTING) {
                throw new IllegalStateException("The server should be WildFly (either ManagementProtocol.HTTP(S)_REMOTING was used or the 'creaper.wildfly' system property was set), but client libraries are AS7-only");
            }
            modelControllerClient = ModelControllerClient.Factory.create((String)this.host, (int)this.port, (CallbackHandler)callbackHandler, (SSLContext)sslContext, (int)this.connectionTimeout, saslOptions);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        try {
            OnlineOptions.connectAndWaitUntilServerBoots(modelControllerClient, this.connectionTimeout, this.bootTimeout);
        }
        catch (Exception e) {
            modelControllerClient.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            throw new IllegalStateException(e);
        }
        return modelControllerClient;
    }

    private static void connectAndWaitUntilServerBoots(ModelControllerClient client, int connectionTimeoutInMillis, int bootTimeoutInMillis) throws IOException, InterruptedException, TimeoutException {
        ModelNodeResult result;
        ModelNode op = new ModelNode();
        op.get("operation").set("whoami");
        op.get("address").setEmptyList();
        long endTime = System.currentTimeMillis() + (long)connectionTimeoutInMillis;
        while (System.currentTimeMillis() < endTime) {
            try {
                client.execute(op);
                break;
            }
            catch (IOException e) {
                Thread.sleep(100L);
            }
        }
        endTime = System.currentTimeMillis() + (long)bootTimeoutInMillis;
        while (System.currentTimeMillis() < endTime) {
            result = new ModelNodeResult(client.execute(op));
            if (result.isSuccess()) {
                return;
            }
            boolean stillBooting = false;
            String failureDescription = result.get("failure-description").asString();
            for (String code : Constants.RESULT_CODES_FOR_BOOT_IN_PROGRESS) {
                if (!failureDescription.startsWith(code)) continue;
                stillBooting = true;
                break;
            }
            if (stillBooting) {
                Thread.sleep(100L);
                continue;
            }
            throw new IllegalStateException("Unknown server state: " + failureDescription);
        }
        result = new ModelNodeResult(client.execute(op));
        if (!result.isSuccess()) {
            throw new TimeoutException("Waiting for server to boot timed out");
        }
    }

    static {
        ManagementClient.OnlineClientFactory.set(new ManagementClient.OnlineClientFactory(){

            @Override
            protected OnlineManagementClient create(OnlineOptions options) throws IOException {
                return new OnlineManagementClientImpl(options);
            }

            @Override
            protected OnlineManagementClient createLazy(OnlineOptions options) {
                return new LazyOnlineManagementClient(options);
            }
        });
    }

    public static final class OptionalOnlineOptions {
        private final Data data;

        private OptionalOnlineOptions(Data data) {
            this.data = data;
        }

        public OptionalOnlineOptions auth(String username, String password) {
            if (this.data.username != null) {
                throw new IllegalStateException("Username and password were already set (" + username + ")");
            }
            if (username == null || username.isEmpty()) {
                throw new IllegalArgumentException("Username must be set");
            }
            if (password == null) {
                throw new IllegalArgumentException("Password must be set");
            }
            this.data.username = username;
            this.data.password = password;
            return this;
        }

        public OptionalOnlineOptions disableLocalAuth() {
            this.data.localAuthDisabled = true;
            return this;
        }

        public OptionalOnlineOptions ssl(SslOptions sslOptions) {
            this.data.sslOptions = sslOptions;
            return this;
        }

        public OptionalOnlineOptions connectionTimeout(int timeoutInMillis) {
            if (timeoutInMillis <= 0) {
                timeoutInMillis = 0;
            }
            this.data.connectionTimeout = timeoutInMillis;
            return this;
        }

        public OptionalOnlineOptions bootTimeout(int timeoutInMillis) {
            if (timeoutInMillis <= 0) {
                timeoutInMillis = 0;
            }
            this.data.bootTimeout = timeoutInMillis;
            return this;
        }

        public OptionalOnlineOptions protocol(ManagementProtocol protocol) {
            if (protocol == null) {
                throw new IllegalArgumentException("Management protocol must be set");
            }
            this.data.protocol = protocol;
            return this;
        }

        public OnlineOptions build() {
            return new OnlineOptions(this.data);
        }
    }

    public static final class ConnectionOnlineOptions {
        private final Data data;

        private ConnectionOnlineOptions(Data data) {
            this.data = data;
        }

        public OptionalOnlineOptions localDefault() {
            this.data.localDefault = true;
            return new OptionalOnlineOptions(this.data);
        }

        public OptionalOnlineOptions hostAndPort(String host, int port) {
            if (this.data.host != null) {
                throw new IllegalStateException("Host and port were already set");
            }
            if (host == null || host.isEmpty()) {
                throw new IllegalArgumentException("Host must be set");
            }
            if (port <= 0) {
                throw new IllegalArgumentException("Port must be set");
            }
            this.data.host = host;
            this.data.port = port;
            return new OptionalOnlineOptions(this.data);
        }

        public OnlineOptions wrap(ModelControllerClient modelControllerClient) {
            if (modelControllerClient == null) {
                throw new IllegalArgumentException("ModelControllerClient to be wrapped must be set");
            }
            this.data.wrappedModelControllerClient = modelControllerClient;
            return new OnlineOptions(this.data);
        }
    }

    public static final class DomainOnlineOptions {
        private final Data data;

        private DomainOnlineOptions(Data data) {
            this.data = data;
        }

        public DomainOnlineOptions forProfile(String profile) {
            assert (this.data.isDomain);
            if (this.data.defaultProfile != null) {
                throw new IllegalStateException("Default profile was already set (" + this.data.defaultProfile + ")");
            }
            this.data.defaultProfile = profile;
            return this;
        }

        public DomainOnlineOptions forHost(String host) {
            assert (this.data.isDomain);
            if (this.data.defaultHost != null) {
                throw new IllegalStateException("Default host was already set (" + this.data.defaultHost + ")");
            }
            this.data.defaultHost = host;
            return this;
        }

        public ConnectionOnlineOptions build() {
            return new ConnectionOnlineOptions(this.data);
        }
    }

    private static final class Data {
        private boolean isStandalone;
        private boolean isDomain;
        private String defaultProfile;
        private String defaultHost;
        private String host;
        private int port;
        private boolean localDefault;
        private ManagementProtocol protocol;
        private int connectionTimeout;
        private int bootTimeout;
        private String username;
        private String password;
        private boolean localAuthDisabled;
        private SslOptions sslOptions;
        private ModelControllerClient wrappedModelControllerClient;

        private Data() {
        }
    }
}

