/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.WorkaroundForWFCORE526_CommandContextImpl;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.AdjustOperationForDomain;
import org.wildfly.extras.creaper.core.online.AutomaticErrorHandlingForCommands;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.ClientAlreadyClosedException;
import org.wildfly.extras.creaper.core.online.FailuresAllowedBlock;
import org.wildfly.extras.creaper.core.online.ModelNodeOperationToCliString;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.NoopCloseFailuresAllowedBlock;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;
import org.wildfly.extras.creaper.core.online.OnlineServerVersion;
import org.wildfly.extras.creaper.core.online.RuntimeCommandFailedException;
import org.wildfly.extras.creaper.core.online.ThisIsWhereTheClientWasClosed;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

final class OnlineManagementClientImpl
implements OnlineManagementClient {
    private static final Logger log = Logger.getLogger(OnlineManagementClient.class);
    private static final String JBOSS_CLI_CONFIG = "jboss.cli.config";
    private final OnlineOptions options;
    private final AdjustOperationForDomain adjustOperationForDomain;
    private ModelControllerClient client;
    private CommandContext cliContext;
    private ServerVersion version;
    private ThisIsWhereTheClientWasClosed closedAt;

    OnlineManagementClientImpl(OnlineOptions options) throws IOException {
        this.options = options;
        this.adjustOperationForDomain = new AdjustOperationForDomain(options);
        this.connect();
    }

    private void connect() throws IOException {
        this.client = this.options.createModelControllerClient();
        try {
            OnlineManagementClientImpl.fakeJbossCliConfigToAvoidWarning();
            this.cliContext = new WorkaroundForWFCORE526_CommandContextImpl(this.options.host, this.options.port);
            this.cliContext.setSilent(true);
            this.cliContext.bindClient(this.client);
        }
        catch (CliInitializationException e) {
            try {
                this.client.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new IOException(e);
        }
        try {
            this.version = OnlineServerVersion.discover(this.client);
            this.checkStandaloneVsDomain();
        }
        catch (Exception e) {
            try {
                this.client.close();
                this.cliContext.disconnectController();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    private static void fakeJbossCliConfigToAvoidWarning() {
        if (System.getProperty(JBOSS_CLI_CONFIG) == null) {
            System.setProperty(JBOSS_CLI_CONFIG, "creaper.doesnt.exist." + System.currentTimeMillis());
        }
    }

    private void checkStandaloneVsDomain() throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-types");
        op.get("address").setEmptyList();
        ModelNodeResult result = this.execute(op);
        List<String> rootChildrenTypes = result.stringListValue();
        if (this.options.isStandalone && !rootChildrenTypes.contains("subsystem")) {
            throw new IllegalStateException("According to the options, this client should be connected to a standalone server, but the server appears to be something else");
        }
        if (this.options.isDomain && !rootChildrenTypes.contains("profile")) {
            throw new IllegalStateException("According to the options, this client should be connected to a domain controller, but the server appears to be something else");
        }
    }

    private void checkClosed() {
        if (this.closedAt != null) {
            throw new ClientAlreadyClosedException(this.closedAt);
        }
    }

    @Override
    public OnlineOptions options() {
        return this.options;
    }

    @Override
    public ServerVersion version() throws IOException {
        return this.version;
    }

    @Override
    public void apply(OnlineCommand ... commands) throws CommandFailedException {
        this.apply(Arrays.asList(commands));
    }

    @Override
    public void apply(Iterable<OnlineCommand> commands) throws CommandFailedException {
        this.checkClosed();
        try {
            OnlineManagementClient client = AutomaticErrorHandlingForCommands.wrap(this);
            OnlineCommandContext ctx = new OnlineCommandContext(client, this.version);
            for (OnlineCommand command : commands) {
                log.infof("Applying command %s", (Object)command);
                command.apply(ctx);
            }
        }
        catch (RuntimeCommandFailedException e) {
            throw e.original;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandFailedException(e);
        }
        catch (Exception e) {
            throw new CommandFailedException(e);
        }
    }

    @Override
    public ModelNodeResult execute(ModelNode operation) throws IOException {
        this.checkClosed();
        operation = this.adjustOperationForDomain.adjust(operation);
        log.debugf("Executing operation %s", (Object)ModelNodeOperationToCliString.convert(operation));
        log.tracef("JSON format:%n%s", (Object)operation.toJSONString(false));
        ModelNode result = this.client.execute(operation);
        return new ModelNodeResult(result);
    }

    @Override
    public ModelNodeResult execute(Operation operation) throws IOException {
        this.checkClosed();
        operation = this.adjustOperationForDomain.adjust(operation);
        log.debugf("Executing operation %s", (Object)ModelNodeOperationToCliString.convert(operation.getOperation()));
        log.tracef("JSON format:%n%s", (Object)operation.getOperation().toJSONString(false));
        ModelNode result = this.client.execute(operation);
        return new ModelNodeResult(result);
    }

    @Override
    public ModelNodeResult execute(String operation) throws CliException, IOException {
        ModelNode parsedOperation;
        this.checkClosed();
        operation = this.adjustOperationForDomain.adjust(operation);
        log.debugf("Executing operation %s", (Object)operation);
        try {
            parsedOperation = this.cliContext.buildRequest(operation);
        }
        catch (CommandFormatException e) {
            throw new CliException(e);
        }
        ModelNode result = this.client.execute(parsedOperation);
        return new ModelNodeResult(result);
    }

    @Override
    public void executeCli(String cliOperation) throws CliException, IOException {
        if (cliOperation.trim().startsWith("connect")) {
            throw new CliException("The 'connect' operation is not supported");
        }
        this.checkClosed();
        cliOperation = this.adjustOperationForDomain.adjust(cliOperation);
        log.debugf("Executing CLI operation %s", (Object)cliOperation);
        try {
            if ("reload".equals(cliOperation.trim())) {
                new Administration(this).reload();
            } else {
                this.cliContext.handle(cliOperation);
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new CliException(e);
        }
        if (this.cliContext.getExitCode() != 0 || this.cliContext.isTerminated()) {
            throw new CliException("CLI operation failed: " + cliOperation);
        }
    }

    @Override
    public void reconnect(int timeoutInSeconds) throws TimeoutException, InterruptedException {
        if (this.options.isWrappedClient) {
            throw new UnsupportedOperationException("Can't reconnect a wrapped client");
        }
        log.info((Object)"Reconnecting the client");
        try {
            this.client.close();
            this.cliContext.disconnectController();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutInSeconds);
        while (System.currentTimeMillis() < endTime) {
            try {
                this.connect();
                return;
            }
            catch (Throwable e) {
                log.info((Object)e.getMessage());
                Thread.sleep(500L);
            }
        }
        throw new TimeoutException("Timeout reconnecting to server");
    }

    @Override
    public FailuresAllowedBlock allowFailures() throws IOException {
        return NoopCloseFailuresAllowedBlock.INSTANCE;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        this.cliContext.disconnectController();
        if (this.closedAt == null) {
            this.closedAt = new ThisIsWhereTheClientWasClosed();
        }
    }
}

