/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ModelNodeResult
extends ModelNode {
    @Deprecated
    public ModelNodeResult() {
    }

    public ModelNodeResult(ModelNode original) {
        this.set(original);
    }

    private String adjustAssertMessage(String message) {
        return message == null || message.isEmpty() ? "" : message + "; ";
    }

    public final boolean isSuccess() {
        if (!this.hasDefined("outcome")) {
            return false;
        }
        String outcome = this.get("outcome").asString();
        return "success".equals(outcome);
    }

    public final boolean isFailed() {
        if (!this.hasDefined("outcome")) {
            return false;
        }
        String outcome = this.get("outcome").asString();
        return "failed".equals(outcome);
    }

    public final void assertSuccess() {
        this.assertSuccess(null);
    }

    public final void assertSuccess(String message) {
        message = this.adjustAssertMessage(message);
        if (!this.isSuccess()) {
            throw new AssertionError((Object)(message + "Expected success, but operation failed: " + this.asString()));
        }
    }

    public final void assertFailed() {
        this.assertFailed(null);
    }

    public final void assertFailed(String message) {
        message = this.adjustAssertMessage(message);
        if (!this.isFailed()) {
            throw new AssertionError((Object)(message + "Expected failure, but operation succeeded: " + this.asString()));
        }
    }

    public final boolean hasDefinedValue() {
        return this.hasDefined("result");
    }

    public final void assertDefinedValue() {
        this.assertDefinedValue(null);
    }

    public final void assertDefinedValue(String message) {
        this.assertSuccess(message);
        message = this.adjustAssertMessage(message);
        if (!this.hasDefinedValue()) {
            throw new AssertionError((Object)(message + "Expected defined 'result', but it's missing: " + this.asString()));
        }
    }

    public final void assertNotDefinedValue() {
        this.assertNotDefinedValue(null);
    }

    public final void assertNotDefinedValue(String message) {
        this.assertSuccess(message);
        message = this.adjustAssertMessage(message);
        if (this.hasDefined("result")) {
            throw new AssertionError((Object)(message + "Expected NOT defined 'result', but it's present: " + this.asString()));
        }
    }

    public final ModelNode value() {
        return this.get("result");
    }

    public final boolean booleanValue() {
        return this.value().asBoolean();
    }

    public final boolean booleanValue(boolean defaultValue) {
        return this.value().asBoolean(defaultValue);
    }

    public final int intValue() {
        return this.value().asInt();
    }

    public final int intValue(int defaultValue) {
        return this.value().asInt(defaultValue);
    }

    public final long longValue() {
        return this.value().asLong();
    }

    public final long longValue(long defaultValue) {
        return this.value().asLong(defaultValue);
    }

    public final double doubleValue() {
        if (!this.hasDefinedValue()) {
            throw new IllegalArgumentException();
        }
        return this.value().asDouble();
    }

    public final double doubleValue(double defaultValue) {
        if (!this.hasDefinedValue()) {
            return defaultValue;
        }
        return this.value().asDouble();
    }

    public final String stringValue() {
        if (!this.hasDefinedValue()) {
            throw new IllegalArgumentException();
        }
        return this.value().asString();
    }

    public final String stringValue(String defaultValue) {
        if (!this.hasDefinedValue()) {
            return defaultValue;
        }
        return this.value().asString();
    }

    public final List<ModelNode> listValue() {
        return this.value().asList();
    }

    public final List<Boolean> booleanListValue() {
        List<ModelNode> listValue = this.listValue();
        ArrayList<Boolean> result = new ArrayList<Boolean>(listValue.size());
        for (ModelNode value : listValue) {
            result.add(value.asBoolean());
        }
        return Collections.unmodifiableList(result);
    }

    public final List<Boolean> booleanListValue(List<Boolean> defaultValue) {
        return this.hasDefinedValue() ? this.booleanListValue() : defaultValue;
    }

    public final List<Integer> intListValue() {
        List<ModelNode> listValue = this.listValue();
        ArrayList<Integer> result = new ArrayList<Integer>(listValue.size());
        for (ModelNode value : listValue) {
            result.add(value.asInt());
        }
        return Collections.unmodifiableList(result);
    }

    public final List<Integer> intListValue(List<Integer> defaultValue) {
        return this.hasDefinedValue() ? this.intListValue() : defaultValue;
    }

    public final List<Long> longListValue() {
        List<ModelNode> listValue = this.listValue();
        ArrayList<Long> result = new ArrayList<Long>(listValue.size());
        for (ModelNode value : listValue) {
            result.add(value.asLong());
        }
        return Collections.unmodifiableList(result);
    }

    public final List<Long> longListValue(List<Long> defaultValue) {
        return this.hasDefinedValue() ? this.longListValue() : defaultValue;
    }

    public final List<Double> doubleListValue() {
        List<ModelNode> listValue = this.listValue();
        ArrayList<Double> result = new ArrayList<Double>(listValue.size());
        for (ModelNode value : listValue) {
            result.add(value.asDouble());
        }
        return Collections.unmodifiableList(result);
    }

    public final List<Double> doubleListValue(List<Double> defaultValue) {
        return this.hasDefinedValue() ? this.doubleListValue() : defaultValue;
    }

    public final List<String> stringListValue() {
        List<ModelNode> listValue = this.listValue();
        ArrayList<String> result = new ArrayList<String>(listValue.size());
        for (ModelNode value : listValue) {
            result.add(value.asString());
        }
        return Collections.unmodifiableList(result);
    }

    public final List<String> stringListValue(List<String> defaultValue) {
        return this.hasDefinedValue() ? this.stringListValue() : defaultValue;
    }

    public final ModelNodeResult forBatchStep(int stepIndex) {
        if (stepIndex < 1) {
            throw new IllegalArgumentException("Step number must be > 0 (first step has index 1)");
        }
        List steps = this.value().asPropertyList();
        if (stepIndex > steps.size()) {
            throw new IllegalArgumentException("No step " + stepIndex + ": " + this.asString());
        }
        return new ModelNodeResult(((Property)steps.get(stepIndex - 1)).getValue());
    }

    public final Iterable<ModelNodeResult> forAllBatchSteps() {
        final List steps = this.value().asPropertyList();
        final int stepsCount = steps.size();
        return new Iterable<ModelNodeResult>(){

            @Override
            public final Iterator<ModelNodeResult> iterator() {
                return new Iterator<ModelNodeResult>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < stepsCount;
                    }

                    @Override
                    public ModelNodeResult next() {
                        ++this.index;
                        return new ModelNodeResult(((Property)steps.get(this.index - 1)).getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public final ModelNode headers() {
        return this.get("response-headers");
    }

    public final boolean isReloadRequired() {
        ModelNode state = this.headers().get("process-state");
        return state.isDefined() && "reload-required".equals(state.asString());
    }

    public final boolean isRestartRequired() {
        ModelNode state = this.headers().get("process-state");
        return state.isDefined() && "restart-required".equals(state.asString());
    }

    public final boolean isFromDomain() {
        return this.hasDefined("server-groups");
    }

    public final ModelNodeResult forServer(String host, String server) {
        if (!this.isFromDomain()) {
            throw new IllegalArgumentException("Can't call forServer on a result that isn't from domain");
        }
        List serverGroups = this.get("server-groups").asPropertyList();
        for (Property serverGroup : serverGroups) {
            ModelNode response = serverGroup.getValue().get(new String[]{"host", host, server, "response"});
            if (!response.isDefined()) continue;
            return new ModelNodeResult(response);
        }
        throw new IllegalArgumentException("No such host or server: host = " + host + ", server = " + server);
    }
}

