/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

final class ModelNodeOperationToCliString {
    private ModelNodeOperationToCliString() {
    }

    static String convert(ModelNode op) {
        try {
            String operation = op.get("operation").asString();
            if (!"composite".equals(operation)) {
                return ModelNodeOperationToCliString.convertSingleOperation(op);
            }
            StringBuilder result = new StringBuilder("composite: ");
            boolean first = true;
            for (ModelNode singleOp : op.get("steps").asList()) {
                if (!first) {
                    result.append(", ");
                }
                first = false;
                result.append(ModelNodeOperationToCliString.convertSingleOperation(singleOp));
            }
            return result.toString();
        }
        catch (Exception e) {
            return op.asString();
        }
    }

    private static String convertSingleOperation(ModelNode op) {
        try {
            String operation = op.get("operation").asString();
            List address = op.get("address").asPropertyList();
            return ModelNodeOperationToCliString.convertAddress(address) + ":" + operation + ModelNodeOperationToCliString.convertParameters(op);
        }
        catch (Exception e) {
            return op.asString();
        }
    }

    private static String convertAddress(List<Property> address) {
        if (address.isEmpty()) {
            return "/";
        }
        StringBuilder result = new StringBuilder();
        for (Property element : address) {
            result.append("/").append(element.getName()).append("=").append(element.getValue().asString());
        }
        return result.toString();
    }

    private static String convertParameters(ModelNode op) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Property parameter : op.asPropertyList()) {
            String name = parameter.getName();
            if ("operation".equals(name) || "address".equals(name) || "operation-headers".equals(name)) continue;
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(name).append("=").append(ModelNodeOperationToCliString.convertValue(parameter.getValue()));
        }
        if (result.length() > 0) {
            return "(" + result.toString() + ")";
        }
        return "";
    }

    private static String convertValue(ModelNode value) {
        switch (value.getType()) {
            case LIST: {
                StringBuilder result = new StringBuilder("[");
                boolean first = true;
                for (ModelNode element : value.asList()) {
                    if (!first) {
                        result.append(", ");
                    }
                    first = false;
                    result.append(ModelNodeOperationToCliString.convertValue(element));
                }
                result.append("]");
                return result.toString();
            }
            case OBJECT: {
                StringBuilder result = new StringBuilder("{");
                boolean first = true;
                for (Property element : value.asPropertyList()) {
                    if (!first) {
                        result.append(", ");
                    }
                    first = false;
                    result.append(element.getName()).append(" => ").append(ModelNodeOperationToCliString.convertValue(element.getValue()));
                }
                result.append("}");
                return result.toString();
            }
            case BYTES: {
                return "<bytes>";
            }
        }
        return value.asString();
    }
}

