/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.client.Operation;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.FailuresAllowedBlock;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;

final class LazyOnlineManagementClient
implements OnlineManagementClient {
    private final OnlineOptions options;
    private OnlineManagementClient delegate;

    LazyOnlineManagementClient(OnlineOptions options) {
        this.options = options;
    }

    private void ensureInitialized() throws IOException {
        if (this.delegate == null) {
            this.delegate = ManagementClient.online(this.options);
        }
    }

    @Override
    public OnlineOptions options() {
        return this.options;
    }

    @Override
    public ServerVersion version() throws IOException {
        this.ensureInitialized();
        return this.delegate.version();
    }

    @Override
    public void apply(OnlineCommand ... commands) throws CommandFailedException {
        try {
            this.ensureInitialized();
        }
        catch (IOException e) {
            throw new CommandFailedException("Failed to create underlying OnlineManagementClient", e);
        }
        this.delegate.apply(commands);
    }

    @Override
    public void apply(Iterable<OnlineCommand> commands) throws CommandFailedException {
        try {
            this.ensureInitialized();
        }
        catch (IOException e) {
            throw new CommandFailedException("Failed to create underlying OnlineManagementClient", e);
        }
        this.delegate.apply(commands);
    }

    @Override
    public ModelNodeResult execute(ModelNode operation) throws IOException {
        this.ensureInitialized();
        return this.delegate.execute(operation);
    }

    @Override
    public ModelNodeResult execute(Operation operation) throws IOException {
        this.ensureInitialized();
        return this.delegate.execute(operation);
    }

    @Override
    public ModelNodeResult execute(String operation) throws CliException, IOException {
        this.ensureInitialized();
        return this.delegate.execute(operation);
    }

    @Override
    public void executeCli(String cliOperation) throws CliException, IOException {
        this.ensureInitialized();
        this.delegate.executeCli(cliOperation);
    }

    @Override
    public void reconnect(int timeoutInSeconds) throws TimeoutException, InterruptedException {
        if (this.delegate != null) {
            this.delegate.reconnect(timeoutInSeconds);
        }
    }

    @Override
    public FailuresAllowedBlock allowFailures() throws IOException {
        this.ensureInitialized();
        return this.delegate.allowFailures();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
    }
}

