/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.security.KeyStore;

public enum KeyStoreType {
    JCEKS("jceks"),
    JKS("jks"),
    PKCS11("pkcs11"),
    PKCS12("pkcs12"),
    PKCS12S2("pkcs12s2");

    public static final KeyStoreType DEFAULT_TYPE;
    private final String typeName;

    private KeyStoreType(String typeName) {
        this.typeName = typeName;
    }

    public String typeName() {
        return this.typeName;
    }

    static {
        String jdkDefaultTypeName = KeyStore.getDefaultType();
        KeyStoreType defaultType = null;
        for (KeyStoreType type : KeyStoreType.values()) {
            if (!type.typeName.equalsIgnoreCase(jdkDefaultTypeName)) continue;
            defaultType = type;
            break;
        }
        DEFAULT_TYPE = defaultType != null ? defaultType : JKS;
    }
}

