/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;
import org.wildfly.extras.creaper.core.online.SslOptions;

final class HttpModelControllerClient
implements ModelControllerClient {
    private static final int NO_TIMEOUT = 0;
    private final String url;
    private final RequestConfig requestConfig;
    private final Registry<ConnectionSocketFactory> registry;
    private final CloseableHttpClient client;

    HttpModelControllerClient(String host, int port, String username, String password, int timeoutMillis, SslOptions ssl) throws IOException {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (timeoutMillis != 0) {
            requestConfigBuilder.setConnectTimeout(timeoutMillis).setSocketTimeout(timeoutMillis);
        }
        this.requestConfig = requestConfigBuilder.build();
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (ssl != null) {
            this.url = "https://" + host + ":" + port + "/management";
            SSLConnectionSocketFactory sslConnectionSocketFactory = ssl.hostnameVerification ? new SSLConnectionSocketFactory(ssl.createSslContext()) : new SSLConnectionSocketFactory(ssl.createSslContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            registryBuilder.register("https", (Object)sslConnectionSocketFactory);
        } else {
            this.url = "http://" + host + ":" + port + "/management";
            registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        }
        this.registry = registryBuilder.build();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (username != null && password != null) {
            credentialsProvider.setCredentials(new AuthScope(host, port, this.getManagementRealm(this.url), "Digest"), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(this.registry)).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(this.requestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelNode execute(ModelNode modelNode) throws IOException {
        ModelNode result;
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)this.buildRequest(modelNode));
        try {
            result = this.parseResponse(response);
        }
        finally {
            response.close();
        }
        return result;
    }

    public ModelNode execute(Operation operation) throws IOException {
        if (!operation.getInputStreams().isEmpty()) {
            throw new IllegalStateException("Operation has one or more attachments which is not allowed.");
        }
        return this.execute(operation.getOperation());
    }

    public ModelNode execute(ModelNode modelNode, OperationMessageHandler handler) throws IOException {
        return this.execute(modelNode);
    }

    public ModelNode execute(Operation operation, OperationMessageHandler handler) throws IOException {
        return this.execute(operation);
    }

    public OperationResponse executeOperation(Operation operation, OperationMessageHandler handler) throws IOException {
        return OperationResponse.Factory.createSimple((ModelNode)this.execute(operation));
    }

    public AsyncFuture<ModelNode> executeAsync(ModelNode modelNode, OperationMessageHandler handler) {
        throw new UnsupportedOperationException("Asynchronous execution is not supported by " + this.getClass().getName());
    }

    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler handler) {
        throw new UnsupportedOperationException("Asynchronous execution is not supported by " + this.getClass().getName());
    }

    public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler handler) {
        throw new UnsupportedOperationException("Asynchronous execution is not supported by " + this.getClass().getName());
    }

    public void close() throws IOException {
        this.client.close();
    }

    private ModelNode parseResponse(CloseableHttpResponse response) throws IOException {
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        int status = response.getStatusLine().getStatusCode();
        if (status != 200 && status != 500) {
            throw new RuntimeException(String.format("Server responded %s%nMessage:%n%s", status, content));
        }
        ModelNode result = ModelNode.fromJSONString((String)content);
        return result;
    }

    private HttpPost buildRequest(ModelNode model) throws UnsupportedEncodingException {
        HttpPost request = new HttpPost(this.url);
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        request.setEntity((HttpEntity)new StringEntity(model.toJSONString(true)));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getManagementRealm(String url) throws IOException {
        String content;
        CloseableHttpClient defaultHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(this.registry)).setDefaultRequestConfig(this.requestConfig).build();
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        post.setEntity((HttpEntity)new StringEntity("[]"));
        CloseableHttpResponse response = null;
        try {
            response = defaultHttpClient.execute((HttpUriRequest)post);
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        finally {
            if (response != null) {
                response.close();
            }
            defaultHttpClient.close();
        }
        if (response.getStatusLine().getStatusCode() == 500) {
            throw new IllegalStateException(String.format("Failed to obtain management realm name. Server responded %d instead of %d. Isn't server authentication turned off while username and password set? Content: %s", 500, 401, content));
        }
        if (response.getStatusLine().getStatusCode() != 401) {
            throw new IllegalStateException(String.format("Failed to obtain management realm name. Server responded %d instead of %d. Content: %s", response.getStatusLine().getStatusCode(), 401, content));
        }
        if (!response.containsHeader("WWW-Authenticate")) {
            throw new IllegalStateException("Failed to obtain management realm name. Missing WWW-Authenticate header in server response.");
        }
        for (HeaderElement el : response.getHeaders("WWW-Authenticate")[0].getElements()) {
            if (!el.getName().equals("Digest realm")) continue;
            return el.getValue();
        }
        throw new IllegalStateException("Failed to obtain management realm name. Digest realm not found in WWW-Authenticate header.");
    }
}

