/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.online;

import java.util.List;
import org.jboss.as.controller.client.Operation;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.extras.creaper.core.online.OnlineOptions;

final class AdjustOperationForDomain {
    private final OnlineOptions options;

    AdjustOperationForDomain(OnlineOptions options) {
        this.options = options;
    }

    ModelNode adjust(ModelNode operation) {
        if (!this.options.isDomain) {
            return operation;
        }
        if ("composite".equals(operation.get("operation").asString())) {
            ModelNode steps = operation.get("steps");
            if (steps.getType() != ModelType.LIST) {
                throw new IllegalArgumentException("Composite operation steps is not a list: " + steps.asString());
            }
            for (ModelNode step : steps.asList()) {
                this.adjust(step);
            }
            return operation;
        }
        ModelNode address = operation.get("address");
        if (address.getType() != ModelType.LIST) {
            throw new IllegalArgumentException("Operation address is not a list: " + address.asString());
        }
        Property prependToAddress = null;
        List addressElements = address.asList();
        for (ModelNode addressElement : addressElements) {
            if (addressElement.getType() != ModelType.PROPERTY) {
                throw new IllegalArgumentException("Operation address element is not a property: " + addressElement.asString());
            }
            Property property = addressElement.asProperty();
            if ("profile".equals(property.getName()) || "host".equals(property.getName())) {
                return operation;
            }
            if ("subsystem".equals(property.getName())) {
                this.checkProfile(operation.asString());
                prependToAddress = new Property("profile", new ModelNode(this.options.defaultProfile));
                break;
            }
            if (!"core-service".equals(property.getName()) || this.options.defaultHost == null) continue;
            prependToAddress = new Property("host", new ModelNode(this.options.defaultHost));
            break;
        }
        if (prependToAddress != null) {
            address.setEmptyList();
            address.add(prependToAddress);
            for (ModelNode addressElement : addressElements) {
                address.add(addressElement);
            }
        }
        return operation;
    }

    Operation adjust(Operation operation) {
        if (!this.options.isDomain) {
            return operation;
        }
        this.adjust(operation.getOperation());
        return operation;
    }

    String adjust(String cliOperation) {
        if (!this.options.isDomain) {
            return cliOperation;
        }
        if (cliOperation.startsWith("/subsystem")) {
            this.checkProfile(cliOperation);
            return "/profile=" + this.options.defaultProfile + cliOperation;
        }
        if (cliOperation.startsWith("/core-service") && this.options.defaultHost != null) {
            return "/host=" + this.options.defaultHost + cliOperation;
        }
        return cliOperation;
    }

    private void checkProfile(String operation) {
        if (this.options.defaultProfile == null) {
            throw new IllegalArgumentException("No default profile, can't perform operation in domain: " + operation);
        }
    }
}

