/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.offline;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.extras.creaper.core.ServerVersion;

final class OfflineServerVersion {
    private static final Pattern ROOT_XMLNS = Pattern.compile("[\"']urn:jboss:domain:(\\d+)\\.(\\d+)[\"']");

    private OfflineServerVersion() {
    }

    static ServerVersion discover(File configurationFile) throws IOException {
        String content = Files.toString((File)configurationFile, (Charset)Charsets.UTF_8);
        Matcher matcher = ROOT_XMLNS.matcher(content);
        if (matcher.find()) {
            String majorStr = matcher.group(1);
            String minorStr = matcher.group(2);
            int major = Integer.parseInt(majorStr);
            int minor = Integer.parseInt(minorStr);
            if (major == 1 && minor == 0) {
                major = 0;
                minor = 0;
            } else if (major == 1 && minor == 1) {
                major = 1;
                minor = 0;
            } else if (major == 1 && minor == 2) {
                major = 1;
                minor = 1;
            } else if (major == 1 && minor == 3) {
                major = 1;
                minor = 2;
            }
            return ServerVersion.from(major, minor, 0);
        }
        throw new IllegalArgumentException("Missing or bad schema version in configuration file " + configurationFile);
    }
}

