/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.offline;

import java.io.File;
import java.io.IOException;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.offline.OfflineManagementClient;
import org.wildfly.extras.creaper.core.offline.OfflineManagementClientImpl;

public final class OfflineOptions {
    public final boolean isStandalone;
    public final boolean isDomain;
    public final String defaultProfile;
    private final File configurationDirectory;
    public final File configurationFile;

    private OfflineOptions(Data data) {
        this.isStandalone = data.isStandalone;
        this.isDomain = data.isDomain;
        this.defaultProfile = data.defaultProfile;
        this.configurationDirectory = data.configurationDirectory;
        this.configurationFile = data.configurationFile;
    }

    public File configurationDirectory() {
        if (this.configurationDirectory == null) {
            throw new IllegalStateException("Configuration directory not set");
        }
        return this.configurationDirectory;
    }

    public static RootDirectoryOfflineOptions standalone() {
        Data data = new Data();
        data.isStandalone = true;
        return new RootDirectoryOfflineOptions(data);
    }

    public static DomainOfflineOptions domain() {
        Data data = new Data();
        data.isDomain = true;
        return new DomainOfflineOptions(data);
    }

    private OfflineManagementClient createManagementClient() throws IOException {
        return new OfflineManagementClientImpl(this);
    }

    static {
        ManagementClient.OfflineClientFactory.set(new ManagementClient.OfflineClientFactory(){

            @Override
            protected OfflineManagementClient create(OfflineOptions options) throws IOException {
                return options.createManagementClient();
            }
        });
    }

    public static final class OptionalOfflineOptions {
        private final Data data;

        private OptionalOfflineOptions(Data data) {
            this.data = data;
        }

        public OfflineOptions build() {
            return new OfflineOptions(this.data);
        }
    }

    public static final class ConfigurationFileOfflineOptions {
        private final Data data;

        public ConfigurationFileOfflineOptions(Data data) {
            this.data = data;
        }

        public OptionalOfflineOptions configurationFile(String fileName) {
            if (fileName == null || fileName.isEmpty()) {
                throw new IllegalArgumentException("Configuration file name must be set");
            }
            if (this.data.configurationDirectory == null) {
                throw new AssertionError();
            }
            this.data.configurationFile = new File(this.data.configurationDirectory, fileName);
            return new OptionalOfflineOptions(this.data);
        }
    }

    public static final class RootDirectoryOfflineOptions {
        private final Data data;

        private RootDirectoryOfflineOptions(Data data) {
            this.data = data;
        }

        public ConfigurationFileOfflineOptions rootDirectory(File rootDirectory) {
            if (rootDirectory == null) {
                throw new IllegalArgumentException("Root directory must be set");
            }
            if (this.data.isStandalone) {
                this.data.configurationDirectory = new File(rootDirectory, "standalone/configuration");
            } else if (this.data.isDomain) {
                this.data.configurationDirectory = new File(rootDirectory, "domain/configuration/");
            } else {
                throw new AssertionError();
            }
            return new ConfigurationFileOfflineOptions(this.data);
        }

        public ConfigurationFileOfflineOptions baseDirectory(File baseDirectory) {
            if (baseDirectory == null) {
                throw new IllegalArgumentException("Base directory must be set");
            }
            this.data.configurationDirectory = new File(baseDirectory, "configuration");
            return new ConfigurationFileOfflineOptions(this.data);
        }

        public OptionalOfflineOptions configurationFile(File configurationFile) {
            if (configurationFile == null) {
                throw new IllegalArgumentException("Configuration file must be set");
            }
            this.data.configurationFile = configurationFile;
            return new OptionalOfflineOptions(this.data);
        }
    }

    public static final class DomainOfflineOptions {
        private final Data data;

        private DomainOfflineOptions(Data data) {
            this.data = data;
        }

        public DomainOfflineOptions forProfile(String profile) {
            assert (this.data.isDomain);
            if (this.data.defaultProfile != null) {
                throw new IllegalStateException("Profile was already set (" + this.data.defaultProfile + ")");
            }
            this.data.defaultProfile = profile;
            return this;
        }

        public RootDirectoryOfflineOptions build() {
            return new RootDirectoryOfflineOptions(this.data);
        }
    }

    private static final class Data {
        private boolean isStandalone;
        private boolean isDomain;
        private String defaultProfile;
        private File configurationDirectory;
        private File configurationFile;

        private Data() {
        }
    }
}

