/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core.offline;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.offline.OfflineManagementClient;
import org.wildfly.extras.creaper.core.offline.OfflineOptions;
import org.wildfly.extras.creaper.core.offline.OfflineServerVersion;

final class OfflineManagementClientImpl
implements OfflineManagementClient {
    private static final Logger log = Logger.getLogger(OfflineManagementClient.class);
    private final OfflineOptions options;
    private final ServerVersion version;

    OfflineManagementClientImpl(OfflineOptions options) throws IOException {
        File configurationFile = options.configurationFile;
        if (!configurationFile.exists()) {
            throw new IOException("Configuration file doesn't exist: " + configurationFile);
        }
        this.options = options;
        this.version = OfflineServerVersion.discover(configurationFile);
    }

    @Override
    public OfflineOptions options() {
        return this.options;
    }

    @Override
    public ServerVersion version() {
        return this.version;
    }

    @Override
    public void apply(OfflineCommand ... commands) throws CommandFailedException {
        this.apply(Arrays.asList(commands));
    }

    @Override
    public void apply(Iterable<OfflineCommand> commands) throws CommandFailedException {
        try {
            OfflineCommandContext ctx = new OfflineCommandContext(this, this.version);
            for (OfflineCommand command : commands) {
                log.infof("Applying command %s", (Object)command);
                command.apply(ctx);
            }
        }
        catch (Exception e) {
            if (e instanceof CommandFailedException) {
                throw (CommandFailedException)e;
            }
            throw new CommandFailedException(e);
        }
    }
}

