/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core;

import org.wildfly.extras.creaper.core.ServerVersionRange;

public final class ServerVersion {
    public static final ServerVersion VERSION_0_0_0 = new ServerVersion(0, 0, 0);
    public static final ServerVersion VERSION_1_0_0 = new ServerVersion(1, 0, 0);
    public static final ServerVersion VERSION_1_1_0 = new ServerVersion(1, 1, 0);
    public static final ServerVersion VERSION_1_2_0 = new ServerVersion(1, 2, 0);
    public static final ServerVersion VERSION_1_3_0 = new ServerVersion(1, 3, 0);
    public static final ServerVersion VERSION_1_4_0 = new ServerVersion(1, 4, 0);
    public static final ServerVersion VERSION_1_5_0 = new ServerVersion(1, 5, 0);
    public static final ServerVersion VERSION_1_6_0 = new ServerVersion(1, 6, 0);
    public static final ServerVersion VERSION_1_7_0 = new ServerVersion(1, 7, 0);
    public static final ServerVersion VERSION_1_8_0 = new ServerVersion(1, 8, 0);
    public static final ServerVersion VERSION_2_0_0 = new ServerVersion(2, 0, 0);
    public static final ServerVersion VERSION_2_1_0 = new ServerVersion(2, 1, 0);
    public static final ServerVersion VERSION_2_2_0 = new ServerVersion(2, 2, 0);
    public static final ServerVersion VERSION_3_0_0 = new ServerVersion(3, 0, 0);
    public static final ServerVersion VERSION_4_0_0 = new ServerVersion(4, 0, 0);
    public static final ServerVersion VERSION_4_1_0 = new ServerVersion(4, 1, 0);
    public static final ServerVersion VERSION_4_2_0 = new ServerVersion(4, 2, 0);
    public static final ServerVersion VERSION_5_0_0 = new ServerVersion(5, 0, 0);
    private static final ServerVersion[] KNOWN_VERSIONS = new ServerVersion[]{VERSION_0_0_0, VERSION_1_0_0, VERSION_1_1_0, VERSION_1_2_0, VERSION_1_3_0, VERSION_1_4_0, VERSION_1_5_0, VERSION_1_6_0, VERSION_1_7_0, VERSION_1_8_0, VERSION_2_0_0, VERSION_2_1_0, VERSION_2_2_0, VERSION_3_0_0, VERSION_4_0_0, VERSION_4_1_0, VERSION_4_2_0, VERSION_5_0_0};
    private final int major;
    private final int minor;
    private final int micro;

    public static ServerVersion from(int major, int minor, int micro) {
        for (ServerVersion knownVersion : KNOWN_VERSIONS) {
            if (knownVersion.major != major || knownVersion.minor != minor || knownVersion.micro != micro) continue;
            return knownVersion;
        }
        return new ServerVersion(major, minor, micro);
    }

    private ServerVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerVersion that = (ServerVersion)o;
        return this.major == that.major && this.minor == that.minor && this.micro == that.micro;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        return result;
    }

    public ServerVersionRange upTo(ServerVersion other) {
        if (this.greaterThan(other)) {
            throw new IllegalArgumentException(this + " must be less than or equal to " + other);
        }
        return new ServerVersionRange(this, true, other, false);
    }

    public ServerVersionRange upToAndIncluding(ServerVersion other) {
        if (this.greaterThan(other)) {
            throw new IllegalArgumentException(this + " must be less than or equal to " + other);
        }
        return new ServerVersionRange(this, true, other, true);
    }

    public boolean equalTo(ServerVersion that) {
        return this.major == that.major && this.minor == that.minor && this.micro == that.micro;
    }

    public boolean lessThan(ServerVersion that) {
        return this.major < that.major || this.major == that.major && this.minor < that.minor || this.major == that.major && this.minor == that.minor && this.micro < that.micro;
    }

    public boolean lessThanOrEqualTo(ServerVersion that) {
        return this.lessThan(that) || this.equalTo(that);
    }

    public boolean greaterThan(ServerVersion that) {
        return !this.lessThanOrEqualTo(that);
    }

    public boolean greaterThanOrEqualTo(ServerVersion that) {
        return !this.lessThan(that);
    }

    @Deprecated
    public boolean inRange(ServerVersion min, ServerVersion max) {
        return this.greaterThanOrEqualTo(min) && this.lessThanOrEqualTo(max);
    }

    public boolean inRange(ServerVersionRange range) {
        return range.contains(this);
    }

    public void assertAtLeast(ServerVersion minimum) {
        this.assertAtLeast(minimum, null);
    }

    public void assertAtLeast(ServerVersion minimum, String message) {
        String defaultMessage = "Expected management version to be at least " + minimum + ", but is " + this;
        message = message == null || message.isEmpty() ? defaultMessage : message + "; " + defaultMessage;
        if (this.lessThan(minimum)) {
            throw new AssertionError((Object)message);
        }
    }
}

