/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.core;

import java.io.IOException;
import org.wildfly.extras.creaper.core.offline.OfflineManagementClient;
import org.wildfly.extras.creaper.core.offline.OfflineOptions;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;

public final class ManagementClient {
    private ManagementClient() {
    }

    public static OnlineManagementClient online(OnlineOptions options) throws IOException {
        return OnlineClientFactory.instance.create(options);
    }

    public static OnlineManagementClient onlineLazy(OnlineOptions options) {
        return OnlineClientFactory.instance.createLazy(options);
    }

    public static OfflineManagementClient offline(OfflineOptions options) throws IOException {
        return OfflineClientFactory.instance.create(options);
    }

    public static abstract class OfflineClientFactory {
        private static OfflineClientFactory instance;

        public static void set(OfflineClientFactory factory) {
            instance = factory;
        }

        protected abstract OfflineManagementClient create(OfflineOptions var1) throws IOException;
    }

    public static abstract class OnlineClientFactory {
        private static OnlineClientFactory instance;

        public static void set(OnlineClientFactory factory) {
            instance = factory;
        }

        protected abstract OnlineManagementClient create(OnlineOptions var1) throws IOException;

        protected abstract OnlineManagementClient createLazy(OnlineOptions var1);
    }
}

