/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;
import org.testcontainers.images.builder.traits.ClasspathTrait;
import org.testcontainers.images.builder.traits.DockerfileTrait;
import org.testcontainers.images.builder.traits.FilesTrait;
import org.testcontainers.images.builder.traits.StringsTrait;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.LazyFuture;

public class ImageFromDockerfile
extends LazyFuture<String>
implements BuildContextBuilderTrait<ImageFromDockerfile>,
ClasspathTrait<ImageFromDockerfile>,
FilesTrait<ImageFromDockerfile>,
StringsTrait<ImageFromDockerfile>,
DockerfileTrait<ImageFromDockerfile> {
    private static final Logger log = LoggerFactory.getLogger(ImageFromDockerfile.class);
    private static final Set<String> imagesToDelete = Sets.newConcurrentHashSet();
    private final String dockerImageName;
    private boolean deleteOnExit = true;
    private final Map<String, Transferable> transferables = new HashMap<String, Transferable>();
    private final Map<String, String> buildArgs = new HashMap<String, String>();
    private Optional<String> dockerFilePath = Optional.empty();

    public ImageFromDockerfile() {
        this("testcontainers/" + Base58.randomString(16).toLowerCase());
    }

    public ImageFromDockerfile(String dockerImageName) {
        this(dockerImageName, true);
    }

    public ImageFromDockerfile(String dockerImageName, boolean deleteOnExit) {
        this.dockerImageName = dockerImageName;
        this.deleteOnExit = deleteOnExit;
    }

    @Override
    public ImageFromDockerfile withFileFromTransferable(String path, Transferable transferable) {
        Transferable oldValue = this.transferables.put(path, transferable);
        if (oldValue != null) {
            log.warn("overriding previous mapping for '{}'", (Object)path);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final String resolve() {
        final Logger logger = DockerLoggerFactory.getLogger(this.dockerImageName);
        DockerClient dockerClient = DockerClientFactory.instance().client();
        try {
            if (this.deleteOnExit) {
                imagesToDelete.add(this.dockerImageName);
            }
            BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

                @Override
                public void onNext(BuildResponseItem item) {
                    super.onNext(item);
                    if (item.isErrorIndicated()) {
                        logger.error(item.getErrorDetail().getMessage());
                    } else {
                        logger.debug(StringUtils.chomp(item.getStream(), "\n"));
                    }
                }
            };
            PipedInputStream in = new PipedInputStream();
            try {
                String string;
                block25: {
                    PipedOutputStream out = new PipedOutputStream(in);
                    try {
                        BuildImageCmd buildImageCmd = dockerClient.buildImageCmd(in);
                        this.configure(buildImageCmd);
                        BuildImageResultCallback exec = buildImageCmd.exec(resultCallback);
                        try (TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(out));){
                            tarArchive.setLongFileMode(3);
                            for (Map.Entry<String, Transferable> entry : this.transferables.entrySet()) {
                                Transferable transferable = entry.getValue();
                                String destination = entry.getKey();
                                transferable.transferTo(tarArchive, destination);
                            }
                            tarArchive.finish();
                        }
                        exec.awaitImageId();
                        string = this.dockerImageName;
                        if (Collections.singletonList(out).get(0) == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(out).get(0) != null) {
                            out.close();
                        }
                        throw throwable;
                    }
                    out.close();
                }
                return string;
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't close DockerClient", e);
        }
    }

    protected void configure(BuildImageCmd buildImageCmd) {
        buildImageCmd.withTag(this.getDockerImageName());
        this.dockerFilePath.ifPresent(buildImageCmd::withDockerfilePath);
        this.buildArgs.forEach(buildImageCmd::withBuildArg);
    }

    public ImageFromDockerfile withBuildArg(String key, String value) {
        this.buildArgs.put(key, value);
        return this;
    }

    public ImageFromDockerfile withBuildArgs(Map<String, String> args) {
        this.buildArgs.putAll(args);
        return this;
    }

    public ImageFromDockerfile withDockerfilePath(String relativePathFromBuildRoot) {
        this.dockerFilePath = Optional.of(relativePathFromBuildRoot);
        return this;
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public Map<String, Transferable> getTransferables() {
        return this.transferables;
    }

    public Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    public Optional<String> getDockerFilePath() {
        return this.dockerFilePath;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> {
            DockerClient dockerClientForCleaning = DockerClientFactory.instance().client();
            try {
                for (String dockerImageName : imagesToDelete) {
                    log.info("Removing image tagged {}", (Object)dockerImageName);
                    try {
                        dockerClientForCleaning.removeImageCmd(dockerImageName).withForce(true).exec();
                    }
                    catch (Throwable e) {
                        log.warn("Unable to delete image " + dockerImageName, e);
                    }
                }
            }
            catch (DockerClientException e) {
                throw new RuntimeException(e);
            }
        }));
    }
}

