/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.io.File;
import org.rnorth.tcpunixsocketproxy.TcpToUnixSocketProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.UnixSocketClientProviderStrategy;

public class ProxiedUnixSocketClientProviderStrategy
extends UnixSocketClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(ProxiedUnixSocketClientProviderStrategy.class);
    public static final int PRIORITY = 0;
    private final File socketFile = new File("/var/run/docker.sock");

    @Override
    protected boolean isApplicable() {
        return this.socketFile.exists();
    }

    @Override
    protected int getPriority() {
        return 0;
    }

    @Override
    public void test() throws InvalidConfigurationException {
        TcpToUnixSocketProxy proxy = new TcpToUnixSocketProxy(this.socketFile);
        try {
            int proxyPort = proxy.start().getPort();
            this.config = this.tryConfiguration("tcp://localhost:" + proxyPort);
            log.debug("Accessing unix domain socket via TCP proxy (/var/run/docker.sock via localhost:" + proxyPort + ")");
        }
        catch (Exception e) {
            proxy.stop();
            throw new InvalidConfigurationException("ping failed", e);
        }
    }

    @Override
    public String getDescription() {
        return "local Unix socket (via TCP proxy)";
    }
}

