/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import org.slf4j.Logger;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public class Slf4jLogConsumer
extends BaseConsumer<Slf4jLogConsumer> {
    private final Logger logger;
    private String prefix = "";

    public Slf4jLogConsumer(Logger logger) {
        this.logger = logger;
    }

    public Slf4jLogConsumer withPrefix(String prefix) {
        this.prefix = "[" + prefix + "] ";
        return this;
    }

    @Override
    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8String();
        utf8String = utf8String.replaceAll("((\\r?\\n)|(\\r))$", "");
        switch (outputType) {
            case END: {
                break;
            }
            case STDOUT: 
            case STDERR: {
                this.logger.info("{}{}: {}", new Object[]{this.prefix, outputType, utf8String});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected outputType " + (Object)((Object)outputType));
            }
        }
    }
}

