/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.model.Frame;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.shaded.org.apache.commons.codec.binary.Base64;
import org.testcontainers.utility.TestcontainersConfiguration;

public class VncRecordingContainer
extends GenericContainer<VncRecordingContainer> {
    private static final String RECORDING_FILE_NAME = "/screen.flv";
    public static final String DEFAULT_VNC_PASSWORD = "secret";
    public static final int DEFAULT_VNC_PORT = 5900;
    private final String targetNetworkAlias;
    private String vncPassword = "secret";
    private int vncPort = 5900;
    private int frameRate = 30;

    public VncRecordingContainer(@NonNull GenericContainer<?> targetContainer) {
        this(targetContainer.getNetwork(), (String)targetContainer.getNetworkAliases().stream().findFirst().orElseThrow(() -> new IllegalStateException("Target container must have a network alias")));
        if (targetContainer == null) {
            throw new NullPointerException("targetContainer is marked @NonNull but is null");
        }
    }

    public VncRecordingContainer(@NonNull Network network, @NonNull String targetNetworkAlias) throws IllegalStateException {
        super(TestcontainersConfiguration.getInstance().getVncRecordedContainerImage());
        if (network == null) {
            throw new NullPointerException("network is marked @NonNull but is null");
        }
        if (targetNetworkAlias == null) {
            throw new NullPointerException("targetNetworkAlias is marked @NonNull but is null");
        }
        this.targetNetworkAlias = targetNetworkAlias;
        this.withNetwork(network);
        this.waitingFor(new GenericContainer.AbstractWaitStrategy(){

            @Override
            protected void waitUntilReady() {
                try {
                    Unreliables.retryUntilTrue((int)((int)this.startupTimeout.toMillis()), (TimeUnit)TimeUnit.MILLISECONDS, () -> {
                        final CountDownLatch latch = new CountDownLatch(1);
                        FrameConsumerResultCallback callback = new FrameConsumerResultCallback(){

                            @Override
                            public void onNext(Frame frame) {
                                if (frame != null && new String(frame.getPayload()).contains("Connected")) {
                                    latch.countDown();
                                }
                            }
                        };
                        try (1 __ = VncRecordingContainer.this.dockerClient.logContainerCmd(VncRecordingContainer.this.containerId).withFollowStream(true).withSince(0).withStdErr(true).exec(callback);){
                            Boolean bl = latch.await(1L, TimeUnit.SECONDS);
                            return bl;
                        }
                    });
                }
                catch (TimeoutException e) {
                    throw new ContainerLaunchException("Timed out waiting for log output", (Exception)((Object)e));
                }
            }
        });
    }

    public VncRecordingContainer withVncPassword(@NonNull String vncPassword) {
        if (vncPassword == null) {
            throw new NullPointerException("vncPassword is marked @NonNull but is null");
        }
        this.vncPassword = vncPassword;
        return this;
    }

    public VncRecordingContainer withVncPort(int vncPort) {
        this.vncPort = vncPort;
        return this;
    }

    public VncRecordingContainer withFrameRate(int frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    @Override
    protected void configure() {
        this.withCreateContainerCmdModifier(it -> it.withEntrypoint("/bin/sh"));
        this.setCommand("-c", "echo '" + Base64.encodeBase64String(this.vncPassword.getBytes()) + "' | base64 -d > /vnc_password && flvrec.py -o " + RECORDING_FILE_NAME + " -d -r " + this.frameRate + " -P /vnc_password " + this.targetNetworkAlias + " " + this.vncPort);
    }

    public InputStream streamRecording() {
        TarArchiveInputStream archiveInputStream = new TarArchiveInputStream(this.dockerClient.copyArchiveFromContainerCmd(this.containerId, RECORDING_FILE_NAME).exec());
        archiveInputStream.getNextEntry();
        return archiveInputStream;
    }

    public void saveRecordingToFile(File file) {
        try (InputStream inputStream = this.streamRecording();){
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public String getTargetNetworkAlias() {
        return this.targetNetworkAlias;
    }

    public String getVncPassword() {
        return this.vncPassword;
    }

    public int getVncPort() {
        return this.vncPort;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    @Override
    public String toString() {
        return "VncRecordingContainer(targetNetworkAlias=" + this.getTargetNetworkAlias() + ", vncPassword=" + this.getVncPassword() + ", vncPort=" + this.getVncPort() + ", frameRate=" + this.getFrameRate() + ")";
    }
}

