/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.SwarmCAConfig;
import com.github.dockerjava.api.model.SwarmDispatcherConfig;
import com.github.dockerjava.api.model.SwarmOrchestration;
import com.github.dockerjava.api.model.SwarmRaftConfig;
import com.github.dockerjava.api.model.TaskDefaults;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.testcontainers.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SwarmSpec
implements Serializable {
    public static final Long serialVersionUID = 1L;
    @JsonProperty(value="Dispatcher")
    private SwarmDispatcherConfig dispatcher;
    @JsonProperty(value="Orchestration")
    private SwarmOrchestration orchestration;
    @JsonProperty(value="CAConfig")
    private SwarmCAConfig caConfig;
    @JsonProperty(value="Raft")
    private SwarmRaftConfig raft;
    @JsonProperty(value="TaskDefaults")
    private TaskDefaults taskDefaults;
    @JsonProperty(value="Name")
    private String name;

    @CheckForNull
    public SwarmDispatcherConfig getDispatcher() {
        return this.dispatcher;
    }

    public SwarmSpec withDispatcher(SwarmDispatcherConfig dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    @CheckForNull
    public SwarmOrchestration getOrchestration() {
        return this.orchestration;
    }

    public SwarmSpec withOrchestration(SwarmOrchestration orchestration) {
        this.orchestration = orchestration;
        return this;
    }

    @CheckForNull
    public SwarmCAConfig getCaConfig() {
        return this.caConfig;
    }

    public SwarmSpec withCaConfig(SwarmCAConfig caConfig) {
        this.caConfig = caConfig;
        return this;
    }

    @CheckForNull
    public SwarmRaftConfig getRaft() {
        return this.raft;
    }

    public SwarmSpec withRaft(SwarmRaftConfig raft) {
        this.raft = raft;
        return this;
    }

    @CheckForNull
    public TaskDefaults getTaskDefaults() {
        return this.taskDefaults;
    }

    public SwarmSpec withTaskDefaults(TaskDefaults taskDefaults) {
        this.taskDefaults = taskDefaults;
        return this;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    public SwarmSpec withName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

