/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.codec.Decoder;
import feign.optionals.OptionalDecoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.support.DefaultGzipDecoder;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"feign.compression.response.enabled"})
@ConditionalOnMissingBean(type={"okhttp3.OkHttpClient"})
@AutoConfigureAfter(value={FeignAutoConfiguration.class})
public class DefaultGzipDecoderConfiguration {
    private ObjectFactory<HttpMessageConverters> messageConverters;

    public DefaultGzipDecoderConfiguration(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"feign.compression.response.useGzipDecoder"})
    public Decoder defaultGzipDecoder() {
        return new OptionalDecoder((Decoder)new ResponseEntityDecoder(new DefaultGzipDecoder(new SpringDecoder(this.messageConverters))));
    }
}

