/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableSpringEncoder
implements Encoder {
    private final Encoder delegate;

    public PageableSpringEncoder(Encoder delegate) {
        this.delegate = delegate;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (this.supports(object)) {
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                template.query("page", new String[]{pageable.getPageNumber() + ""});
                template.query("size", new String[]{pageable.getPageSize() + ""});
                if (pageable.getSort() != null) {
                    this.applySort(template, pageable.getSort());
                }
            } else if (object instanceof Sort) {
                Sort sort = (Sort)object;
                this.applySort(template, sort);
            }
        } else if (this.delegate != null) {
            this.delegate.encode(object, bodyType, template);
        } else {
            throw new EncodeException("PageableSpringEncoder does not support the given object " + object.getClass() + " and no delegate was provided for fallback!");
        }
    }

    private void applySort(RequestTemplate template, Sort sort) {
        Collection existingSorts = (Collection)template.queries().get("sort");
        ArrayList<String> sortQueries = existingSorts != null ? new ArrayList<String>(existingSorts) : new ArrayList();
        for (Sort.Order order : sort) {
            sortQueries.add(order.getProperty() + "," + order.getDirection());
        }
        if (!sortQueries.isEmpty()) {
            template.query("sort", sortQueries);
        }
    }

    protected boolean supports(Object object) {
        return object instanceof Pageable || object instanceof Sort;
    }
}

