/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.ribbon;

import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonProperties;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.openfeign.ribbon.FeignLoadBalancer;
import org.springframework.cloud.openfeign.ribbon.FeignRetryPolicy;
import org.springframework.cloud.openfeign.ribbon.RibbonResponseStatusCodeException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StreamUtils;

public class RetryableFeignLoadBalancer
extends FeignLoadBalancer
implements ServiceInstanceChooser {
    private final LoadBalancedRetryFactory loadBalancedRetryFactory;

    public RetryableFeignLoadBalancer(ILoadBalancer lb, IClientConfig clientConfig, ServerIntrospector serverIntrospector, LoadBalancedRetryFactory loadBalancedRetryFactory) {
        super(lb, clientConfig, serverIntrospector);
        this.loadBalancedRetryFactory = loadBalancedRetryFactory;
        this.setRetryHandler((RetryHandler)new DefaultLoadBalancerRetryHandler(clientConfig));
    }

    @Override
    public FeignLoadBalancer.RibbonResponse execute(final FeignLoadBalancer.RibbonRequest request, IClientConfig configOverride) throws IOException {
        Request.Options options;
        if (configOverride != null) {
            RibbonProperties ribbon = RibbonProperties.from((IClientConfig)configOverride);
            options = new Request.Options(ribbon.connectTimeout(this.connectTimeout), ribbon.readTimeout(this.readTimeout));
        } else {
            options = new Request.Options(this.connectTimeout, this.readTimeout);
        }
        final LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryFactory.createRetryPolicy(this.getClientName(), (ServiceInstanceChooser)this);
        RetryTemplate retryTemplate = new RetryTemplate();
        BackOffPolicy backOffPolicy = this.loadBalancedRetryFactory.createBackOffPolicy(this.getClientName());
        retryTemplate.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        RetryListener[] retryListeners = this.loadBalancedRetryFactory.createRetryListeners(this.getClientName());
        if (retryListeners != null && retryListeners.length != 0) {
            retryTemplate.setListeners(retryListeners);
        }
        retryTemplate.setRetryPolicy((RetryPolicy)(retryPolicy == null ? new NeverRetryPolicy() : new FeignRetryPolicy(request.toHttpRequest(), retryPolicy, this, this.getClientName())));
        return (FeignLoadBalancer.RibbonResponse)retryTemplate.execute((RetryCallback)new RetryCallback<FeignLoadBalancer.RibbonResponse, IOException>(){

            public FeignLoadBalancer.RibbonResponse doWithRetry(RetryContext retryContext) throws IOException {
                ServiceInstance service;
                Request feignRequest = null;
                if (retryContext instanceof LoadBalancedRetryContext && (service = ((LoadBalancedRetryContext)retryContext).getServiceInstance()) != null) {
                    feignRequest = ((FeignLoadBalancer.RibbonRequest)request.replaceUri(RetryableFeignLoadBalancer.this.reconstructURIWithServer(new Server(service.getHost(), service.getPort()), request.getUri()))).toRequest();
                }
                if (feignRequest == null) {
                    feignRequest = request.toRequest();
                }
                Response response = request.client().execute(feignRequest, options);
                if (retryPolicy != null && retryPolicy.retryableStatusCode(response.status())) {
                    byte[] byteArray = response.body() == null ? new byte[]{} : StreamUtils.copyToByteArray((InputStream)response.body().asInputStream());
                    response.close();
                    throw new RibbonResponseStatusCodeException(RetryableFeignLoadBalancer.this.clientName, response, byteArray, request.getUri());
                }
                return new FeignLoadBalancer.RibbonResponse(request.getUri(), response);
            }
        }, (RecoveryCallback)new LoadBalancedRecoveryCallback<FeignLoadBalancer.RibbonResponse, Response>(){

            protected FeignLoadBalancer.RibbonResponse createResponse(Response response, URI uri) {
                return new FeignLoadBalancer.RibbonResponse(uri, response);
            }
        });
    }

    @Override
    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(FeignLoadBalancer.RibbonRequest request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(false, false, this.getRetryHandler(), requestConfig);
    }

    public ServiceInstance choose(String serviceId) {
        return new RibbonLoadBalancerClient.RibbonServer(serviceId, this.getLoadBalancer().chooseServer((Object)serviceId));
    }
}

